/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.python.pydev.overview_ruler.MinimapOverviewRuler;
import org.python.pydev.overview_ruler.MinimapOverviewRulerPreferencesPage;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.IModelListener;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.IScopesParser;
import org.python.pydev.shared_core.string.ICharacterPairMatcher2;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.OrderedSet;
import org.python.pydev.shared_core.utils.Reflection;
import org.python.pydev.shared_ui.editor.BaseEditorCursorListener;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.editor.IPyEditListener2;
import org.python.pydev.shared_ui.editor.PyEditNotifier;
import org.python.pydev.shared_ui.outline.IOutlineModel;

public abstract class BaseEditor
extends TextEditor
implements IBaseEditor {
    protected final Collection<IPyEditListener> registeredEditListeners = new OrderedSet();
    private final Object initFinishedLock = new Object();
    protected boolean initFinished = false;
    protected final PyEditNotifier notifier;
    public Map<String, Object> cache = new HashMap<String, Object>();
    protected final List<IModelListener> modelListeners = new ArrayList<IModelListener>();
    IOutlineModel outlineModel;

    public BaseEditor() {
        this.notifier = new PyEditNotifier(this);
        try {
            Field field = AbstractTextEditor.class.getDeclaredField("fSelectionChangedListener");
            field.setAccessible(true);
            field.set((Object)this, new ISelectionChangedListener(){
                private Runnable fRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ISourceViewer sourceViewer = BaseEditor.this.getSourceViewer();
                        if (sourceViewer != null && sourceViewer.getDocument() != null) {
                            BaseEditor.this.updateSelectionDependentActions();
                        }
                    }
                };
                private Display fDisplay;

                public void selectionChanged(SelectionChangedEvent event) {
                    Display current = Display.getCurrent();
                    if (current != null) {
                        this.fRunnable.run();
                    } else {
                        if (this.fDisplay == null) {
                            this.fDisplay = BaseEditor.this.getSite().getShell().getDisplay();
                        }
                        this.fDisplay.asyncExec(this.fRunnable);
                    }
                    BaseEditor.this.handleCursorPositionChanged();
                }
            });
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPyeditListener(IPyEditListener listener) {
        Collection<IPyEditListener> collection = this.registeredEditListeners;
        synchronized (collection) {
            this.registeredEditListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePyeditListener(IPyEditListener listener) {
        Collection<IPyEditListener> collection = this.registeredEditListeners;
        synchronized (collection) {
            this.registeredEditListeners.remove(listener);
        }
    }

    public List<IPyEditListener> getAllListeners() {
        return this.getAllListeners(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPyEditListener> getAllListeners(boolean waitInit) {
        if (waitInit) {
            while (!this.initFinished) {
                Object object = this.getInitFinishedLock();
                synchronized (object) {
                    try {
                        if (!this.initFinished) {
                            this.getInitFinishedLock().wait();
                        }
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        }
        ArrayList<IPyEditListener> listeners = new ArrayList<IPyEditListener>();
        List<IPyEditListener> editListeners = this.getAdditionalEditorListeners();
        if (editListeners != null) {
            listeners.addAll(editListeners);
        }
        Collection<IPyEditListener> collection = this.registeredEditListeners;
        synchronized (collection) {
            listeners.addAll(this.registeredEditListeners);
        }
        return listeners;
    }

    protected List<IPyEditListener> getAdditionalEditorListeners() {
        return null;
    }

    protected Object getInitFinishedLock() {
        return this.initFinishedLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markInitFinished() {
        this.initFinished = true;
        Object object = this.getInitFinishedLock();
        synchronized (object) {
            this.getInitFinishedLock().notifyAll();
        }
    }

    public void setSelection(int offset, int length) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        sourceViewer.setSelectedRange(offset, length);
        sourceViewer.revealRange(offset, length);
    }

    public ISourceViewer getEditorSourceViewer() {
        return this.getSourceViewer();
    }

    public IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getAnnotationModel((Object)this.getEditorInput());
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    public abstract void revealModelNodes(ISimpleNode[] var1);

    public boolean hasSameInput(IBaseEditor edit) {
        IEditorInput thisInput = this.getEditorInput();
        IEditorInput otherInput = (IEditorInput)edit.getEditorInput();
        if (thisInput == null || otherInput == null) {
            return false;
        }
        if (thisInput == otherInput || thisInput.equals(otherInput)) {
            return true;
        }
        IResource r1 = (IResource)thisInput.getAdapter(IResource.class);
        IResource r2 = (IResource)otherInput.getAdapter(IResource.class);
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.equals((Object)r2);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        super.performSave(overwrite, progressMonitor);
        try {
            this.getParserManager().notifySaved((IBaseEditor)this);
            this.notifier.notifyOnSave();
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        BaseEditorCursorListener cursorListener = new BaseEditorCursorListener(this);
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        textWidget.addMouseListener((MouseListener)cursorListener);
        textWidget.addKeyListener((KeyListener)cursorListener);
    }

    public IDocument getDocument() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getDocument((Object)this.getEditorInput());
        }
        return null;
    }

    public IProject getProject() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            IFile file = (IFile)((FileEditorInput)editorInput).getAdapter(IFile.class);
            return file.getProject();
        }
        return null;
    }

    public IFile getIFile() {
        try {
            IEditorInput editorInput = this.getEditorInput();
            return (IFile)editorInput.getAdapter(IFile.class);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public File getEditorFile() {
        File f = null;
        IEditorInput editorInput = this.getEditorInput();
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file != null) {
            IPath location = file.getLocation();
            if (location != null) {
                IPath path = location.makeAbsolute();
                f = path.toFile();
            }
        } else {
            try {
                if (editorInput instanceof IURIEditorInput) {
                    IURIEditorInput iuriEditorInput = (IURIEditorInput)editorInput;
                    return new File(iuriEditorInput.getURI());
                }
            }
            catch (Throwable throwable) {}
            try {
                IPath path = (IPath)Reflection.invoke((Object)editorInput, (String)"getPath", (Object[])new Object[0]);
                f = path.toFile();
            }
            catch (Throwable throwable) {}
        }
        return f;
    }

    protected abstract BaseParserManager getParserManager();

    public void addModelListener(IModelListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.modelListeners.contains(listener)) {
            this.modelListeners.add(listener);
        }
    }

    public void removeModelListener(IModelListener listener) {
        Assert.isNotNull((Object)listener);
        this.modelListeners.remove(listener);
    }

    protected void fireModelChanged(ISimpleNode root) {
        for (IModelListener listener : new ArrayList<IModelListener>(this.modelListeners)) {
            try {
                listener.modelChanged(root);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    protected void fireParseErrorChanged(ErrorDescription errorDesc) {
        for (IModelListener listener : new ArrayList<IModelListener>(this.modelListeners)) {
            listener.errorChanged(errorDesc);
        }
    }

    public abstract TextSelectionUtils createTextSelectionUtils();

    public void notifyCursorPositionChanged() {
        if (!this.initFinished) {
            return;
        }
        TextSelectionUtils ps = this.createTextSelectionUtils();
        for (IPyEditListener listener : this.getAllListeners()) {
            try {
                if (!(listener instanceof IPyEditListener2)) continue;
                ((IPyEditListener2)((Object)listener)).handleCursorPositionChanged(this, ps);
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
    }

    public abstract ICharacterPairMatcher2 getPairMatcher();

    public abstract IScopesParser createScopesParser();

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        if (MinimapOverviewRulerPreferencesPage.useMinimap()) {
            IOutlineModel outlineModel = (IOutlineModel)this.getAdapter(IOutlineModel.class);
            MinimapOverviewRuler ruler = new MinimapOverviewRuler(this.getAnnotationAccess(), sharedColors, outlineModel);
            for (AnnotationPreference preference : this.getAnnotationPreferences().getAnnotationPreferences()) {
                if (!preference.contributesToHeader()) continue;
                ruler.addHeaderAnnotationType(preference.getAnnotationType());
            }
            return ruler;
        }
        return super.createOverviewRuler(sharedColors);
    }

    public Object getAdapter(Class adapter) {
        if (IOutlineModel.class.equals((Object)adapter)) {
            if (this.outlineModel == null) {
                this.outlineModel = this.createOutlineModel();
            }
            return this.outlineModel;
        }
        return super.getAdapter(adapter);
    }

    public abstract IOutlineModel createOutlineModel();

    public void dispose() {
        if (this.outlineModel != null) {
            this.outlineModel.dispose();
            this.outlineModel = null;
        }
        super.dispose();
    }
}

