/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_ui.editor.IVerticalIndentGuidePreferencesProvider;
import org.python.pydev.shared_ui.editor.IVerticalLinesIndentGuideComputer;
import org.python.pydev.shared_ui.editor.VerticalLinesToDraw;

public class TextVerticalLinesIndentGuide
implements IVerticalLinesIndentGuideComputer {
    private IVerticalIndentGuidePreferencesProvider verticalIndentPrefs;

    public TextVerticalLinesIndentGuide(IVerticalIndentGuidePreferencesProvider verticalIndentPrefs) {
        Assert.isNotNull((Object)verticalIndentPrefs);
        this.verticalIndentPrefs = verticalIndentPrefs;
    }

    @Override
    public int getTabWidth() {
        return this.verticalIndentPrefs.getTabWidth();
    }

    @Override
    public boolean getShowIndentGuide() {
        return this.verticalIndentPrefs.getShowIndentGuide();
    }

    @Override
    public Color getColor(StyledText styledText) {
        return this.verticalIndentPrefs.getColor(styledText);
    }

    @Override
    public int getTransparency() {
        return this.verticalIndentPrefs.getTransparency();
    }

    @Override
    public void dispose() {
        this.verticalIndentPrefs.dispose();
    }

    @Override
    public SortedMap<Integer, List<VerticalLinesToDraw>> computeVerticalLinesToDrawInRegion(StyledText styledText, int topIndex, int bottomIndex) {
        int originalTopIndex = topIndex;
        TreeMap<Integer, List<VerticalLinesToDraw>> lineToVerticalLinesToDraw = new TreeMap<Integer, List<VerticalLinesToDraw>>();
        int lineHeight = styledText.getLineHeight();
        int lineCount = styledText.getLineCount();
        if (bottomIndex > lineCount - 1) {
            bottomIndex = lineCount - 1;
        }
        while (topIndex > 0) {
            String string = styledText.getLine(topIndex);
            int firstCharPosition = TextSelectionUtils.getFirstCharPosition((String)string);
            if (firstCharPosition != string.length()) break;
            --topIndex;
        }
        int line = topIndex;
        while (line <= bottomIndex) {
            String string = styledText.getLine(line);
            int firstCharPosition = TextSelectionUtils.getFirstCharPosition((String)string);
            if (firstCharPosition == string.length()) {
                List previousLine = (List)lineToVerticalLinesToDraw.get(line - 1);
                if (previousLine != null) {
                    ArrayList<VerticalLinesToDraw> newLst = new ArrayList<VerticalLinesToDraw>(previousLine.size());
                    for (VerticalLinesToDraw verticalLinesToDraw : previousLine) {
                        newLst.add(verticalLinesToDraw.copyChangingYOffset(lineHeight));
                    }
                    lineToVerticalLinesToDraw.put(line, newLst);
                }
            } else if (firstCharPosition != 0) {
                this.computeLine(string, firstCharPosition, styledText, line, lineHeight, lineToVerticalLinesToDraw);
            }
            ++line;
        }
        if (originalTopIndex != topIndex) {
            Set entrySet = lineToVerticalLinesToDraw.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if ((Integer)next.getKey() >= originalTopIndex) break;
                iterator.remove();
            }
        }
        return lineToVerticalLinesToDraw;
    }

    private void computeLine(String string, int firstCharPosition, StyledText styledText, int line, int lineHeight, SortedMap<Integer, List<VerticalLinesToDraw>> lineToVerticalLinesToDraw) {
        int lineOffset = -1;
        String spaces = string.substring(0, firstCharPosition);
        int level = 0;
        int whitespacesFound = 0;
        int tabWidthUsed = this.getTabWidth();
        int j = 0;
        while (j < firstCharPosition - 1) {
            char c = spaces.charAt(j);
            if (c == '\t') {
                ++level;
                whitespacesFound = 0;
            } else if (++whitespacesFound % tabWidthUsed == 0) {
                ++level;
                whitespacesFound = 0;
            }
            if (level > 0) {
                if (lineOffset == -1) {
                    lineOffset = styledText.getOffsetAtLine(line);
                }
                Point point1 = styledText.getLocationAtOffset(lineOffset + j + 1);
                int xCoord = point1.x + 3;
                VerticalLinesToDraw verticalLinesToDraw = new VerticalLinesToDraw(xCoord, point1.y, xCoord, point1.y + lineHeight);
                ArrayList<VerticalLinesToDraw> lst = (ArrayList<VerticalLinesToDraw>)lineToVerticalLinesToDraw.get(line);
                if (lst == null) {
                    lst = new ArrayList<VerticalLinesToDraw>();
                    lineToVerticalLinesToDraw.put(line, lst);
                }
                lst.add(verticalLinesToDraw);
                --level;
            }
            ++j;
        }
    }
}

