/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.editor.IVerticalLinesIndentGuideComputer;
import org.python.pydev.shared_ui.editor.VerticalLinesToDraw;

public class VerticalIndentGuidesPainter
implements PaintListener,
ModifyListener,
ExtendedModifyListener,
TextChangeListener {
    private StyledText styledText;
    private boolean inDraw;
    private Rectangle currClientArea;
    private int currCharCount;
    private Map<Integer, List<VerticalLinesToDraw>> lineToVerticalLinesToDraw;
    private StyledTextContent content;
    private final IVerticalLinesIndentGuideComputer indentGuide;
    private int lastXOffset = -1;
    private int lastYOffset = -1;
    private int currTabWidth = -1;
    private boolean askFullRedraw = true;

    public void dispose() {
        this.styledText = null;
        this.currClientArea = null;
        this.lineToVerticalLinesToDraw = null;
        this.content = null;
        this.indentGuide.dispose();
    }

    public VerticalIndentGuidesPainter(IVerticalLinesIndentGuideComputer indentGuide) {
        Assert.isNotNull((Object)indentGuide);
        this.indentGuide = indentGuide;
    }

    public void paintControl(PaintEvent e) {
        block24: {
            if (this.inDraw || this.styledText == null || this.styledText.isDisposed()) {
                return;
            }
            try {
                this.inDraw = true;
                boolean showIndentGuide = this.indentGuide.getShowIndentGuide();
                if (!showIndentGuide) {
                    return;
                }
                int xOffset = this.styledText.getHorizontalPixel();
                int yOffset = this.styledText.getTopPixel();
                boolean styledTextContentChanged = this.getStyledTextContentChangedAndStoreNew();
                boolean clientAreaChanged = this.getClientAreaChangedAndStoreNew();
                boolean charCountChanged = this.getCharCountChangedAndStoreNew();
                boolean tabWidthChanged = this.getTabWidthChangedAndStoreNew();
                boolean redrawAll = styledTextContentChanged || clientAreaChanged || charCountChanged || tabWidthChanged || xOffset != this.lastXOffset || yOffset != this.lastYOffset;
                StyledTextContent currentContent = this.content;
                if (this.currClientArea == null || this.currClientArea.width < 5 || this.currClientArea.height < 5 || this.currCharCount < 1 || currentContent == null || this.currTabWidth <= 0) {
                    return;
                }
                try {
                    this.lastXOffset = xOffset;
                    this.lastYOffset = yOffset;
                    int topIndex = JFaceTextUtil.getPartialTopIndex((StyledText)this.styledText);
                    int bottomIndex = JFaceTextUtil.getPartialBottomIndex((StyledText)this.styledText);
                    if (redrawAll) {
                        this.lineToVerticalLinesToDraw = this.indentGuide.computeVerticalLinesToDrawInRegion(this.styledText, topIndex, bottomIndex);
                        if (this.askFullRedraw) {
                            this.askFullRedraw = false;
                            if (Math.abs(this.currClientArea.height - e.gc.getClipping().height) > 40) {
                                this.styledText.redraw();
                            }
                        }
                    }
                    if (this.lineToVerticalLinesToDraw == null) break block24;
                    Throwable throwable = null;
                    Object var14_16 = null;
                    try (AutoCloseable temp = this.configGC(e.gc);){
                        Collection<List<VerticalLinesToDraw>> values = this.lineToVerticalLinesToDraw.values();
                        for (List<VerticalLinesToDraw> list : values) {
                            for (VerticalLinesToDraw verticalLinesToDraw : list) {
                                verticalLinesToDraw.drawLine(e.gc);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e1) {
                    Log.log((Throwable)e1);
                }
            }
            finally {
                this.inDraw = false;
            }
        }
    }

    private boolean getStyledTextContentChangedAndStoreNew() {
        StyledTextContent oldContent;
        StyledTextContent currentContent = this.styledText.getContent();
        if (currentContent != (oldContent = this.content)) {
            if (oldContent != null) {
                oldContent.removeTextChangeListener((TextChangeListener)this);
            }
            this.content = currentContent;
            currentContent.addTextChangeListener((TextChangeListener)this);
            return true;
        }
        return false;
    }

    private AutoCloseable configGC(final GC gc) {
        final int lineStyle = gc.getLineStyle();
        final int alpha = gc.getAlpha();
        final int[] lineDash = gc.getLineDash();
        final Color foreground = gc.getForeground();
        final Color background = gc.getBackground();
        gc.setForeground(this.indentGuide.getColor(this.styledText));
        gc.setBackground(this.styledText.getBackground());
        gc.setAlpha(this.indentGuide.getTransparency());
        gc.setLineStyle(6);
        gc.setLineDash(new int[]{1, 2});
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                gc.setForeground(foreground);
                gc.setBackground(background);
                gc.setAlpha(alpha);
                gc.setLineStyle(lineStyle);
                gc.setLineDash(lineDash);
            }
        };
    }

    boolean getClientAreaChangedAndStoreNew() {
        Rectangle clientArea = this.styledText.getClientArea();
        if (this.currClientArea == null || !this.currClientArea.equals((Object)clientArea)) {
            this.currClientArea = clientArea;
            return true;
        }
        return false;
    }

    boolean getCharCountChangedAndStoreNew() {
        int charCount = this.styledText.getCharCount();
        if (this.currCharCount != charCount) {
            this.currCharCount = charCount;
            return true;
        }
        return false;
    }

    boolean getTabWidthChangedAndStoreNew() {
        int tabWidth = this.indentGuide.getTabWidth();
        if (this.currTabWidth != tabWidth) {
            this.currTabWidth = tabWidth;
            return true;
        }
        return false;
    }

    public void setStyledText(StyledText styledText) {
        if (this.styledText != null) {
            this.styledText.removeModifyListener((ModifyListener)this);
            this.styledText.removeExtendedModifyListener((ExtendedModifyListener)this);
            if (this.content != null) {
                this.content.removeTextChangeListener((TextChangeListener)this);
            }
        }
        this.styledText = styledText;
        this.content = this.styledText.getContent();
        this.styledText.addModifyListener((ModifyListener)this);
        this.styledText.addExtendedModifyListener((ExtendedModifyListener)this);
        this.content.addTextChangeListener((TextChangeListener)this);
    }

    public void modifyText(ModifyEvent e) {
        this.currClientArea = null;
        this.askFullRedraw = true;
    }

    public void modifyText(ExtendedModifyEvent event) {
        this.currClientArea = null;
        this.askFullRedraw = true;
    }

    public void textChanging(TextChangingEvent event) {
        this.currClientArea = null;
        this.askFullRedraw = true;
    }

    public void textChanged(TextChangedEvent event) {
        this.currClientArea = null;
        this.askFullRedraw = true;
    }

    public void textSet(TextChangedEvent event) {
        this.currClientArea = null;
        this.askFullRedraw = true;
    }
}

