/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.field_editors;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.python.pydev.shared_ui.tooltips.presenter.ToolTipPresenterHandler;

public class LinkFieldEditor
extends FieldEditor {
    private Link link;
    private final SelectionListener selectionListener;
    private final String tooltip;
    private final ToolTipPresenterHandler tooltipPresenter;

    public LinkFieldEditor(String name, String linkText, Composite parent, SelectionListener selectionListener) {
        this(name, linkText, parent, selectionListener, null, null);
    }

    public LinkFieldEditor(String name, String linkText, Composite parent, SelectionListener selectionListener, String tooltip, ToolTipPresenterHandler tooltipPresenter) {
        this.tooltip = tooltip;
        this.init(name, linkText);
        this.selectionListener = selectionListener;
        this.tooltipPresenter = tooltipPresenter;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.link.getLayoutData();
        gd.horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Link link = this.getLinkControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        link.setLayoutData((Object)gd);
    }

    public Link getLinkControl(Composite parent) {
        if (this.link == null) {
            this.link = new Link(parent, 0);
            this.link.setFont(parent.getFont());
            String text = this.getLabelText();
            if (text != null) {
                this.link.setText(text);
            }
            if (this.tooltip != null) {
                if (this.tooltipPresenter != null) {
                    this.link.setData("TIP_DATA", (Object)this.tooltip);
                    this.tooltipPresenter.install((Control)this.link);
                } else {
                    this.link.setToolTipText(this.tooltip);
                }
            }
            this.link.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    LinkFieldEditor.this.link = null;
                }
            });
            this.link.addSelectionListener(this.getSelectionListener());
        } else {
            this.checkParent((Control)this.link, parent);
        }
        return this.link;
    }

    public Link getLink() {
        return this.link;
    }

    private SelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.link.setEnabled(enabled);
    }
}

