/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.outline;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.IModelListener;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_ui.outline.BaseOutlinePage;
import org.python.pydev.shared_ui.outline.IOutlineModel;
import org.python.pydev.shared_ui.outline.IParsedItem;

public abstract class BaseModel
implements IOutlineModel {
    protected final IBaseEditor editor;
    private WeakReference<BaseOutlinePage> outlinePageRef;
    protected final IModelListener modelListener;
    protected IParsedItem root = null;
    public final ICallbackWithListeners<IOutlineModel> onModelChanged = new CallbackWithListeners();

    protected abstract IParsedItem createParsedItemFromSimpleNode(ISimpleNode var1);

    @Override
    public ICallbackWithListeners<IOutlineModel> getOnModelChangedCallback() {
        return this.onModelChanged;
    }

    @Override
    public void setOutlinePage(BaseOutlinePage baseOutlinePage) {
        this.outlinePageRef = new WeakReference<BaseOutlinePage>(baseOutlinePage);
    }

    public BaseModel(IBaseEditor editor) {
        this.editor = editor;
        this.modelListener = new IModelListener(){

            public void modelChanged(final ISimpleNode ast) {
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            IParsedItem newRoot = BaseModel.this.createParsedItemFromSimpleNode(ast);
                            BaseModel.this.setRoot(newRoot);
                        }
                    }
                });
            }

            public void errorChanged(final ErrorDescription errorDesc) {
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            IParsedItem newRoot = BaseModel.this.duplicateRootAddingError(errorDesc);
                            BaseModel.this.setRoot(newRoot);
                        }
                    }
                });
            }
        };
        this.root = this.createInitialRootFromEditor();
        if (this.root == null) {
            Log.log((String)("null root created in: " + this + " (should not happen)."));
        }
        editor.addModelListener(this.modelListener);
    }

    protected abstract IParsedItem createInitialRootFromEditor();

    protected abstract IParsedItem duplicateRootAddingError(ErrorDescription var1);

    @Override
    public void dispose() {
        this.editor.removeModelListener(this.modelListener);
        this.onModelChanged.unregisterAllListeners();
        this.root = null;
    }

    @Override
    public IParsedItem getRoot() {
        return this.root;
    }

    private void patchRootHelper(IParsedItem oldItem, IParsedItem newItem, ArrayList<IParsedItem> itemsToRefresh, ArrayList<IParsedItem> itemsToUpdate) {
        IParsedItem[] oldChildren;
        IParsedItem[] newChildren = newItem.getChildren();
        if (newChildren.length != (oldChildren = oldItem.getChildren()).length) {
            oldItem.updateTo(newItem);
            itemsToRefresh.add(oldItem);
        } else {
            String newTitle;
            int i = 0;
            while (i < oldChildren.length) {
                this.patchRootHelper(oldChildren[i], newChildren[i], itemsToRefresh, itemsToUpdate);
                ++i;
            }
            String oldTitle = oldItem.toString();
            if (!oldTitle.equals(newTitle = newItem.toString()) || !oldItem.sameNodeType(newItem)) {
                itemsToUpdate.add(oldItem);
            }
            oldItem.updateShallow(newItem);
        }
    }

    public void setRoot(IParsedItem newRoot) {
        this.onModelChanged.call((Object)this);
        try {
            if (this.root != null) {
                ArrayList<IParsedItem> itemsToRefresh = new ArrayList<IParsedItem>();
                ArrayList<IParsedItem> itemsToUpdate = new ArrayList<IParsedItem>();
                this.patchRootHelper(this.root, newRoot, itemsToRefresh, itemsToUpdate);
                if (this.outlinePageRef != null) {
                    int itemsToRefreshSize;
                    BaseOutlinePage outlinePage = (BaseOutlinePage)((Object)this.outlinePageRef.get());
                    if (outlinePage == null) {
                        return;
                    }
                    if (outlinePage.isDisconnectedFromTree()) {
                        return;
                    }
                    int itemsToUpdateSize = itemsToUpdate.size();
                    if (itemsToUpdateSize > 0) {
                        outlinePage.updateItems(itemsToUpdate.toArray(new IParsedItem[itemsToUpdateSize]));
                    }
                    if ((itemsToRefreshSize = itemsToRefresh.size()) > 0) {
                        outlinePage.refreshItems(itemsToRefresh.toArray(new IParsedItem[itemsToRefreshSize]));
                    }
                }
            } else {
                Log.log((String)"No old model root?");
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }
}

