/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.proposals;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.shared_ui.proposals.ICompletionStyleToggleEnabler;

public class PyCompletionPresentationUpdater {
    private StyleRange fRememberedStyleRange;

    private static Color getForegroundColor(StyledText text) {
        return Display.getDefault().getSystemColor(3);
    }

    private static Color getBackgroundColor(StyledText text) {
        return Display.getDefault().getSystemColor(7);
    }

    public void repairPresentation(ITextViewer viewer) {
        if (this.fRememberedStyleRange != null) {
            if (viewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 viewer2 = (ITextViewerExtension2)viewer;
                if (viewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                    IRegion modelRange = extension.widgetRange2ModelRange((IRegion)new Region(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length));
                    if (modelRange != null) {
                        viewer2.invalidateTextPresentation(modelRange.getOffset(), modelRange.getLength());
                    }
                } else {
                    viewer2.invalidateTextPresentation(this.fRememberedStyleRange.start + viewer.getVisibleRegion().getOffset(), this.fRememberedStyleRange.length);
                }
            } else {
                viewer.invalidateTextPresentation();
            }
        }
        if (viewer instanceof ICompletionStyleToggleEnabler) {
            ICompletionStyleToggleEnabler pySourceViewer = (ICompletionStyleToggleEnabler)viewer;
            pySourceViewer.setInToggleCompletionStyle(false);
        }
    }

    public void updateStyle(ITextViewer viewer, int initialOffset, int len) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int widgetCaret = text.getCaretOffset();
        int modelCaret = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            modelCaret = extension.widgetOffset2ModelOffset(widgetCaret);
        } else {
            IRegion visibleRegion = viewer.getVisibleRegion();
            modelCaret = widgetCaret + visibleRegion.getOffset();
        }
        if (modelCaret >= initialOffset + len) {
            this.repairPresentation(viewer);
            return;
        }
        int offset = widgetCaret;
        int length = initialOffset + len - modelCaret;
        Color foreground = PyCompletionPresentationUpdater.getForegroundColor(text);
        Color background = PyCompletionPresentationUpdater.getBackgroundColor(text);
        StyleRange range = text.getStyleRangeAtOffset(offset);
        int fontStyle = range != null ? range.fontStyle : 0;
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = new StyleRange(offset, length, foreground, background, fontStyle);
        if (range != null) {
            this.fRememberedStyleRange.strikeout = range.strikeout;
            this.fRememberedStyleRange.underline = range.underline;
        }
        try {
            if (viewer instanceof ICompletionStyleToggleEnabler) {
                ICompletionStyleToggleEnabler pySourceViewer = (ICompletionStyleToggleEnabler)viewer;
                pySourceViewer.setInToggleCompletionStyle(true);
            }
            text.setStyleRange(this.fRememberedStyleRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fRememberedStyleRange = null;
        }
    }
}

