/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.tooltips.presenter;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.tooltips.presenter.IInformationPresenterAsTooltip;
import org.python.pydev.shared_ui.tooltips.presenter.IInformationPresenterControlManager;

public abstract class AbstractInformationPresenter
implements DefaultInformationControl.IInformationPresenter,
DefaultInformationControl.IInformationPresenterExtension,
IInformationPresenterAsTooltip {
    public static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    protected IInformationPresenterControlManager informationPresenterControlManager;
    protected Object data;

    public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        return this.updatePresentation((Drawable)display, hoverInfo, presentation, maxWidth, maxHeight);
    }

    protected String correctLineDelimiters(String str) {
        FastStringBuffer buf = new FastStringBuffer();
        for (String s : StringUtils.splitInLines((String)str)) {
            boolean found = false;
            while (s.endsWith("\r") || s.endsWith("\n")) {
                found = true;
                s = s.substring(0, s.length() - 1);
            }
            buf.append(s);
            if (!found) continue;
            buf.append(LINE_DELIM);
        }
        str = buf.toString();
        return str;
    }

    @Override
    public void setInformationPresenterControlManager(IInformationPresenterControlManager informationPresenterControlManager) {
        this.informationPresenterControlManager = informationPresenterControlManager;
    }

    public void hideInformationControl(boolean activateEditor, boolean restoreFocus) {
        if (this.informationPresenterControlManager != null) {
            this.informationPresenterControlManager.hideInformationControl(activateEditor, restoreFocus);
        }
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }
}

