/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.utils;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.python.pydev.shared_core.log.Log;

public class UIUtils {
    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static Shell getActiveShell() {
        IWorkbenchWindow window;
        Shell shell = UIUtils.getDisplay().getActiveShell();
        if (shell == null && (window = UIUtils.getActiveWorkbenchWindow()) != null) {
            shell = window.getShell();
        }
        return shell;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage workbenchPage = UIUtils.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        return workbenchPage.getActiveEditor();
    }

    public static IWorkbenchPart getActivePart() {
        IWorkbenchPage workbenchPage = UIUtils.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        return workbenchPage.getActivePart();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow workbench = UIUtils.getActiveWorkbenchWindow();
        if (workbench == null) {
            return null;
        }
        return workbench.getActivePage();
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static ViewPart getView(String viewId, boolean forceVisible) {
        IWorkbenchWindow workbenchWindow;
        block5: {
            workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow != null) break block5;
            return null;
        }
        try {
            IWorkbenchPage page = workbenchWindow.getActivePage();
            if (forceVisible) {
                return (ViewPart)page.showView(viewId, null, 2);
            }
            IViewReference viewReference = page.findViewReference(viewId);
            if (viewReference != null) {
                return (ViewPart)viewReference.getView(false);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }
}

