/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.jython;

import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyJavaType;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.pydev.core.NullOutputStream;
import org.python.pydev.core.log.Log;
import org.python.pydev.jython.ExitScriptException;
import org.python.pydev.jython.IPythonInterpreter;
import org.python.pydev.jython.PythonInterpreterWrapper;
import org.python.pydev.jython.PythonInterpreterWrapperNotShared;
import org.python.pydev.jython.ScriptOutput;
import org.python.pydev.jython.ui.JyScriptingPreferencesPage;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.ConsoleColorCache;
import org.python.pydev.shared_ui.bundle.BundleInfo;
import org.python.pydev.shared_ui.bundle.IBundleInfo;
import org.python.util.PythonInterpreter;

public class JythonPlugin
extends AbstractUIPlugin {
    private static final File[] EMPTY_FILES = new File[0];
    private static final boolean DEBUG = false;
    public static boolean DEBUG_RELOAD = true;
    public static boolean IN_TESTS = false;
    private static String LOAD_FILE_SCRIPT = "print '--->  reloading', r'%s'\nimport sys                    \nf = open(r'%s')               \ntry:                          \n    toExec = f.read()         \nfinally:                      \n    f.close()                 \n%s                            \n";
    public static IBundleInfo info;
    private static JythonPlugin plugin;
    private static Bundle[] bundles;
    private static final Object lock;
    private static Map<File, Tuple<Long, Object>> codeCache;
    private static MessageConsole fConsole;
    private static IOConsoleOutputStream fOutputStream;
    private static IOConsoleOutputStream fErrorStream;

    static {
        lock = new Object();
        codeCache = new HashMap<File, Tuple<Long, Object>>();
    }

    public static synchronized void setDebugReload(boolean b) {
        if (b != DEBUG_RELOAD) {
            LOAD_FILE_SCRIPT = !b ? "#" + LOAD_FILE_SCRIPT : LOAD_FILE_SCRIPT.substring(1);
            DEBUG_RELOAD = b;
        }
    }

    public static IBundleInfo getBundleInfo() {
        if (info == null) {
            info = new BundleInfo(JythonPlugin.getDefault().getBundle());
        }
        return info;
    }

    public static void setBundleInfo(IBundleInfo b) {
        info = b;
    }

    public JythonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bundles = context.getBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupJython() {
        Object object = lock;
        synchronized (object) {
            block12: {
                if (bundles != null && plugin != null) {
                    Properties prop2 = new Properties();
                    prop2.put("python.home", FileUtils.getFileAbsolutePath((File)plugin.getPluginRootDir()));
                    prop2.put("python.path", FileUtils.getFileAbsolutePath((File)JythonPlugin.getJySrcDirFile()));
                    prop2.put("python.console.encoding", "UTF-8");
                    prop2.put("python.security.respectJavaAccessibility", "false");
                    try {
                        try {
                            AllBundleClassLoader allBundleClassLoader = new AllBundleClassLoader(((Object)((Object)plugin)).getClass().getClassLoader());
                            PySystemState.initialize((Properties)System.getProperties(), (Properties)prop2, (String[])new String[0], (ClassLoader)allBundleClassLoader);
                            List<String> packageNames = allBundleClassLoader.setBundlesAndGetPackageNames(bundles);
                            int size = packageNames.size();
                            int i = 0;
                            while (i < size) {
                                String name = packageNames.get(i);
                                if (!name.contains("internal")) {
                                    int iToSplit = name.indexOf(59);
                                    if (iToSplit != -1) {
                                        name = name.substring(0, iToSplit);
                                    }
                                    PySystemState.add_package((String)name);
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                            bundles = null;
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        bundles = null;
                        throw throwable;
                    }
                    bundles = null;
                }
            }
        }
    }

    private File getPluginRootDir() {
        try {
            Path relative = new Path(".");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static JythonPlugin getDefault() {
        return plugin;
    }

    public static File getJythonLibDir() {
        try {
            Path relative = new Path("Lib");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getFileWithinJySrc(String f) {
        try {
            IPath relative = new Path("jysrc").addTrailingSeparator().append(f);
            return JythonPlugin.getBundleInfo().getRelativePath(relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getJySrcDirFile() {
        try {
            Path relative = new Path("jysrc");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Throwable exec(HashMap<String, Object> locals, String fileToExec, IPythonInterpreter interpreter) {
        File fileWithinJySrc = JythonPlugin.getFileWithinJySrc(fileToExec);
        return JythonPlugin.exec(locals, interpreter, fileWithinJySrc, new File[]{fileWithinJySrc.getParentFile()}, new String[0]);
    }

    public static List<Throwable> execAll(HashMap<String, Object> locals, String startingWith, IPythonInterpreter interpreter) {
        File jySrc = JythonPlugin.getJySrcDirFile();
        File additionalScriptingLocation = JyScriptingPreferencesPage.getAdditionalScriptingLocation();
        return JythonPlugin.execAll(locals, startingWith, interpreter, new File[]{jySrc, additionalScriptingLocation}, null);
    }

    public static List<Throwable> execAll(HashMap<String, Object> locals, String startingWith, IPythonInterpreter interpreter, File[] beneathFolders, File[] additionalPythonpathFolders) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ArrayList<File> pythonpath = new ArrayList<File>();
        pythonpath.addAll(Arrays.asList(beneathFolders));
        if (additionalPythonpathFolders != null) {
            pythonpath.addAll(Arrays.asList(additionalPythonpathFolders));
        }
        File[] pythonpathFolders = pythonpath.toArray(new File[pythonpath.size()]);
        File[] fileArray = beneathFolders;
        int n = beneathFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file != null) {
                File[] files;
                if (!file.exists()) {
                    String msg = "The folder:" + file + " does not exist and therefore cannot be used to " + "find scripts to run starting with:" + startingWith;
                    Log.log((int)4, (String)msg, null);
                    errors.add(new RuntimeException(msg));
                }
                File[] fileArray2 = files = JythonPlugin.getFilesBeneathFolder(startingWith, file);
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    File f = fileArray2[n4];
                    Throwable throwable = JythonPlugin.exec(locals, interpreter, f, pythonpathFolders, new String[0]);
                    if (throwable != null) {
                        errors.add(throwable);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return errors;
    }

    public static File[] getFilesBeneathFolder(final String startingWith, File jySrc) {
        File[] files = jySrc.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.startsWith(startingWith) && name.endsWith(".py");
            }
        });
        if (files == null) {
            files = EMPTY_FILES;
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable exec(HashMap<String, Object> locals, IPythonInterpreter interpreter, File fileToExec, File[] pythonpathFolders, String ... argv) {
        if (locals == null) {
            locals = new HashMap();
        }
        if (interpreter == null) {
            return null;
        }
        locals.put("__file__", fileToExec.toString());
        try {
            String codeObjName;
            Map<File, Tuple<Long, Object>> map = codeCache;
            synchronized (map) {
                String fileName = fileToExec.getName();
                if (!fileName.endsWith(".py")) {
                    throw new RuntimeException("The script to be executed must be a python file. Name:" + fileName);
                }
                codeObjName = "code" + fileName.substring(0, fileName.indexOf(46));
                String codeObjTimestampName = String.valueOf(codeObjName) + "Timestamp";
                for (Map.Entry<String, Object> entry : locals.entrySet()) {
                    interpreter.set(entry.getKey(), entry.getValue());
                }
                boolean regenerate = false;
                if (interpreter instanceof PythonInterpreterWrapperNotShared) {
                    regenerate = true;
                }
                Tuple<Long, Object> timestamp = codeCache.get(fileToExec);
                long lastModified = fileToExec.lastModified();
                if (timestamp == null || (Long)timestamp.o1 != lastModified) {
                    regenerate = true;
                }
                if (!regenerate) {
                    PyObject obj = interpreter.get(codeObjName);
                    PyObject pyTime = interpreter.get(codeObjTimestampName);
                    if (obj == null || pyTime == null || !pyTime.__tojava__(Long.class).equals(timestamp.o1)) {
                        interpreter.set(codeObjName, timestamp.o2);
                        interpreter.set(codeObjTimestampName, timestamp.o1);
                    }
                }
                if (regenerate) {
                    String path = FileUtils.getFileAbsolutePath((File)fileToExec);
                    StringBuffer strPythonPathFolders = new StringBuffer();
                    strPythonPathFolders.append("[");
                    File[] fileArray = pythonpathFolders;
                    int n = pythonpathFolders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file != null) {
                            strPythonPathFolders.append("r'");
                            strPythonPathFolders.append(FileUtils.getFileAbsolutePath((File)file));
                            strPythonPathFolders.append("',");
                        }
                        ++n2;
                    }
                    strPythonPathFolders.append("]");
                    StringBuffer addToSysPath = new StringBuffer();
                    addToSysPath.append("if not hasattr(sys, 'PYDEV_PYTHONPATH_SET') or sys.PYDEV_PYTHONPATH_SET != ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append(":\n");
                    addToSysPath.append("    sys.PYDEV_PYTHONPATH_SET = ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append("\n");
                    addToSysPath.append("    sys.path += ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append("\n");
                    if (argv.length > 0) {
                        addToSysPath.append("sys.argv = [");
                        String[] stringArray = argv;
                        int n3 = argv.length;
                        n = 0;
                        while (n < n3) {
                            String s = stringArray[n];
                            addToSysPath.append(s);
                            addToSysPath.append(",");
                            ++n;
                        }
                        addToSysPath.append("];");
                        addToSysPath.append("\n");
                    }
                    String toExec = StringUtils.format((String)LOAD_FILE_SCRIPT, (Object[])new Object[]{path, path, addToSysPath.toString()});
                    interpreter.exec(toExec);
                    String exec = StringUtils.format((String)"%s = compile(toExec, r'%s', 'exec')", (Object[])new Object[]{codeObjName, path});
                    interpreter.exec(exec);
                    interpreter.set(codeObjTimestampName, lastModified);
                    PyObject codeObj = interpreter.get(codeObjName);
                    codeCache.put(fileToExec, (Tuple<Long, Object>)new Tuple((Object)lastModified, (Object)codeObj));
                }
            }
            interpreter.exec(StringUtils.format((String)"exec(%s)", (Object[])new Object[]{codeObjName}));
        }
        catch (Throwable e) {
            if (!IN_TESTS && JythonPlugin.getDefault() == null) {
                return null;
            }
            if (e instanceof ExitScriptException) {
                return null;
            }
            if (e instanceof PyException) {
                PyException pE = (PyException)e;
                if (pE.type instanceof PyJavaType) {
                    PyJavaType t = (PyJavaType)pE.type;
                    if (t.getName() != null && t.getName().equals("org.python.pydev.jython.ExitScriptException")) {
                        return null;
                    }
                } else if (pE.type instanceof PyClass) {
                    PyClass t = (PyClass)pE.type;
                    if (t.__name__ != null && t.__name__.equals("SystemExit")) {
                        return null;
                    }
                }
            }
            if (JyScriptingPreferencesPage.getShowScriptingOutput()) {
                Log.log((int)4, (String)("Error while executing:" + fileToExec), (Throwable)e);
            }
            return e;
        }
        return null;
    }

    private static MessageConsole getConsole() {
        try {
            if (fConsole == null) {
                fConsole = new MessageConsole("PyDev Scripting", JythonPlugin.getBundleInfo().getImageCache().getDescriptor("icons/python_scripting.png"));
                fOutputStream = fConsole.newOutputStream();
                fErrorStream = fConsole.newOutputStream();
                HashMap<IOConsoleOutputStream, String> themeConsoleStreamToColor = new HashMap<IOConsoleOutputStream, String>();
                themeConsoleStreamToColor.put(fOutputStream, "console.output");
                themeConsoleStreamToColor.put(fErrorStream, "console.error");
                fConsole.setAttribute("themeConsoleStreamToColor", themeConsoleStreamToColor);
                ConsoleColorCache.getDefault().keepConsoleColorsSynched((IOConsole)fConsole);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{fConsole});
            }
            return fConsole;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IPythonInterpreter newPythonInterpreter() {
        return JythonPlugin.newPythonInterpreter(true, true);
    }

    public static IPythonInterpreter newPythonInterpreter(boolean redirect, boolean shareSys) {
        JythonPlugin.setupJython();
        PythonInterpreter interpreter = shareSys ? new PythonInterpreterWrapper() : new PythonInterpreterWrapperNotShared();
        if (redirect) {
            interpreter.setOut(new ScriptOutput(new ICallback0<IOConsoleOutputStream>(){

                public IOConsoleOutputStream call() {
                    JythonPlugin.getConsole();
                    return fOutputStream;
                }
            }));
            interpreter.setErr(new ScriptOutput(new ICallback0<IOConsoleOutputStream>(){

                public IOConsoleOutputStream call() {
                    JythonPlugin.getConsole();
                    return fErrorStream;
                }
            }));
        } else {
            interpreter.setErr((OutputStream)NullOutputStream.singleton);
            interpreter.setOut((OutputStream)NullOutputStream.singleton);
        }
        return interpreter;
    }

    public static class AllBundleClassLoader
    extends ClassLoader {
        private Bundle[] bundles;
        private final String[] PACKAGES_MUST_START_WITH = new String[]{"com.python.pydev", "org.eclipse.jface", "org.junit", "org.python"};

        public AllBundleClassLoader(ClassLoader parent) {
            super(parent);
        }

        /*
         * Unable to fully structure code
         */
        public Class loadClass(String className) throws ClassNotFoundException {
            try {
                return super.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                searchedClass = e.getMessage();
                i = 0;
                ** while (i < this.PACKAGES_MUST_START_WITH.length)
            }
lbl-1000:
            // 1 sources

            {
                if (searchedClass.startsWith(this.PACKAGES_MUST_START_WITH[i])) {
                    len = this.bundles.length;
                    j = 0;
                    while (j < len) {
                        try {
                            bundle = this.bundles[j];
                            if (bundle.getState() == 32) {
                                return bundle.loadClass(className);
                            }
                        }
                        catch (Throwable v0) {}
                        ++j;
                    }
                    break;
                }
                ++i;
                continue;
            }
lbl22:
            // 2 sources

            throw e;
        }

        private boolean addPackageNames(Bundle bundle, List<String> addNamesToThisList, String commaSeparatedPackages) {
            boolean addedSomePackage = false;
            if (commaSeparatedPackages != null) {
                List packageNames = StringUtils.split((String)commaSeparatedPackages, (char)',');
                int size = packageNames.size();
                int i = 0;
                while (i < size) {
                    String pname = ((String)packageNames.get(i)).trim();
                    int j = 0;
                    while (j < this.PACKAGES_MUST_START_WITH.length) {
                        if (pname.startsWith(this.PACKAGES_MUST_START_WITH[j])) {
                            addedSomePackage = true;
                            addNamesToThisList.add(pname);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return addedSomePackage;
        }

        public List<String> setBundlesAndGetPackageNames(Bundle[] bundles) {
            ArrayList<Bundle> acceptedBundles = new ArrayList<Bundle>();
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < bundles.length) {
                boolean addedSomePackage = false;
                Bundle bundle = bundles[i];
                Dictionary headers = bundle.getHeaders();
                addedSomePackage |= this.addPackageNames(bundle, names, (String)headers.get("Provide-Package"));
                if (addedSomePackage |= this.addPackageNames(bundle, names, (String)headers.get("Export-Package"))) {
                    acceptedBundles.add(bundle);
                }
                ++i;
            }
            this.bundles = acceptedBundles.toArray(new Bundle[acceptedBundles.size()]);
            return names;
        }
    }
}

