/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.inlinelocal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.visitors.LocalVariablesVisitor;
import org.python.pydev.refactoring.coderefactoring.inlinelocal.InlineLocalChangeProcessor;
import org.python.pydev.refactoring.coderefactoring.inlinelocal.InlineLocalRequestProcessor;
import org.python.pydev.refactoring.core.base.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.base.RefactoringInfo;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.messages.Messages;

public class InlineLocalRefactoring
extends AbstractPythonRefactoring {
    private InlineLocalRequestProcessor requestProcessor;
    private IChangeProcessor changeProcessor;

    public InlineLocalRefactoring(RefactoringInfo info) {
        super(info);
        this.initWizard();
    }

    private void initWizard() {
        this.requestProcessor = new InlineLocalRequestProcessor(this.info);
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ArrayList<IChangeProcessor> processors = new ArrayList<IChangeProcessor>();
        this.changeProcessor = new InlineLocalChangeProcessor(this.getName(), this.info, this.requestProcessor);
        processors.add(this.changeProcessor);
        return processors;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        AbstractScopeNode<?> scope = this.info.getScopeAdapter();
        ITextSelection selection = this.info.getUserSelection();
        Object node = scope.getASTNode();
        LocalVariablesVisitor visitor = new LocalVariablesVisitor();
        try {
            node.accept((VisitorIF)visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<Name> variables = visitor.getVariables();
        Name selectedVariable = this.findSelectedVariable(selection, variables);
        if (selectedVariable == null) {
            this.status.addFatalError(Messages.validationNoNameSelected);
            return this.status;
        }
        List<Name> relatedVariables = this.findAllRelatedVariables(variables, selectedVariable);
        Assign assignment = this.findAssignment(relatedVariables);
        if (assignment == null) {
            String id = selectedVariable.id;
            this.status.addFatalError(Messages.format(Messages.inlinelocalNoAssignment, id));
            return this.status;
        }
        if (!this.isValid(relatedVariables)) {
            return this.status;
        }
        this.requestProcessor.setAssign(assignment);
        this.requestProcessor.setVariables(relatedVariables);
        return this.status;
    }

    private boolean isValid(List<Name> variables) {
        int assignCounter = 0;
        for (Name variable : variables) {
            if (variable.parent instanceof Assign) {
                Assign assign = (Assign)variable.parent;
                exprType[] exprTypeArray = assign.targets;
                int n = assign.targets.length;
                int n2 = 0;
                while (n2 < n) {
                    exprType x = exprTypeArray[n2];
                    if (x == variable) {
                        ++assignCounter;
                        break;
                    }
                    ++n2;
                }
            }
            if (variable.ctx != 6 && variable.ctx != 8) continue;
            this.status.addFatalError(Messages.format(Messages.inlineLocalParameter, variable.getId()));
            return false;
        }
        if (assignCounter > 1) {
            this.status.addFatalError(Messages.format(Messages.inlineLocalMultipleAssignments, variables.get(0).getId()));
            return false;
        }
        return true;
    }

    private Assign findAssignment(List<Name> relatedVariables) {
        for (Name variable : relatedVariables) {
            SimpleNode parent = variable.parent;
            if (!(parent instanceof Assign)) continue;
            Assign assign = (Assign)parent;
            exprType[] exprTypeArray = assign.targets;
            int n = assign.targets.length;
            int n2 = 0;
            while (n2 < n) {
                exprType x = exprTypeArray[n2];
                if (x == variable) {
                    return assign;
                }
                ++n2;
            }
        }
        return null;
    }

    private List<Name> findAllRelatedVariables(List<Name> variables, Name selectedVariable) {
        LinkedList<Name> relatedVariables = new LinkedList<Name>();
        for (Name variable : variables) {
            if (!variable.id.equals(selectedVariable.id)) continue;
            relatedVariables.add(variable);
        }
        return relatedVariables;
    }

    private Name findSelectedVariable(ITextSelection selection, List<Name> variables) {
        int selectionOffset = selection.getOffset();
        for (Name variable : variables) {
            int nodeLength = variable.id.length();
            int nodeOffsetBegin = NodeUtils.getOffset((IDocument)this.info.getDocument(), (SimpleNode)variable);
            int nodeOffsetEnd = nodeOffsetBegin + nodeLength;
            if (selectionOffset < nodeOffsetBegin || selectionOffset > nodeOffsetEnd) continue;
            return variable;
        }
        return null;
    }

    public String getName() {
        return Messages.inlineLocalLabel;
    }

    public InlineLocalRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }
}

