/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core.base;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.autoedit.TestIndentPrefs;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.refactoring.ast.PythonModuleManager;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.structure.Tuple;

public class RefactoringInfo {
    private IFile sourceFile;
    private IDocument doc;
    private ITextSelection userSelection;
    private ITextSelection extendedSelection;
    private ModuleAdapter moduleAdapter;
    private final IPythonNature nature;
    private final IGrammarVersionProvider versionProvider;
    public final IIndentPrefs indentPrefs;
    private PythonModuleManager moduleManager;
    private AbstractScopeNode<?> scopeAdapter;
    private IProject project;
    private File realFile;

    public RefactoringInfo(PyEdit edit) throws MisconfigurationException {
        this(edit, (ITextSelection)edit.getSelectionProvider().getSelection());
    }

    public RefactoringInfo(IDocument document, ITextSelection selection, IGrammarVersionProvider versionProvider) {
        this.sourceFile = null;
        this.nature = null;
        this.versionProvider = versionProvider;
        this.doc = document;
        this.indentPrefs = SharedCorePlugin.inTestMode() ? new TestIndentPrefs(document.get().indexOf(9) < 0, 4) : DefaultIndentPrefs.get();
        this.initInfo(selection);
    }

    public RefactoringInfo(PyEdit edit, ITextSelection selection) throws MisconfigurationException {
        Tuple infoForFile;
        IEditorInput input = edit.getEditorInput();
        this.indentPrefs = edit.getIndentPrefs();
        IPythonNature localNature = edit.getPythonNature();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput editorInput = (IFileEditorInput)input;
            this.sourceFile = editorInput.getFile();
            this.realFile = this.sourceFile != null ? this.sourceFile.getLocation().toFile() : null;
        } else {
            this.realFile = edit.getEditorFile();
        }
        if (localNature == null && (infoForFile = PydevPlugin.getInfoForFile((File)this.realFile)) != null && infoForFile.o1 != null) {
            localNature = (IPythonNature)infoForFile.o1;
        }
        this.nature = localNature;
        this.doc = edit.getDocument();
        this.project = edit.getProject();
        this.versionProvider = this.nature;
        this.initInfo(selection);
    }

    private void initInfo(ITextSelection selection) {
        if (this.nature != null) {
            this.moduleManager = new PythonModuleManager(this.nature);
        }
        try {
            this.moduleAdapter = VisitorFactory.createModuleAdapter(this.moduleManager, this.realFile, this.doc, this.nature, this.versionProvider);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.extendedSelection = null;
        this.userSelection = this.moduleAdapter.normalizeSelection(selection);
    }

    public IProject getProject() {
        return this.project;
    }

    public ModuleAdapter getModuleAdapter() {
        return this.moduleAdapter;
    }

    public List<IClassDefAdapter> getClasses() {
        return this.moduleAdapter.getClasses();
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public ITextSelection getExtendedSelection() {
        if (this.extendedSelection == null) {
            this.extendedSelection = new TextSelection(this.doc, this.userSelection.getOffset(), this.userSelection.getLength());
            if (this.getScopeAdapter() != null) {
                this.extendedSelection = this.moduleAdapter.normalizeSelection(VisitorFactory.createSelectionExtension(this.getScopeAdapter(), this.extendedSelection));
            }
        }
        return this.extendedSelection;
    }

    public ITextSelection getUserSelection() {
        return this.userSelection;
    }

    public ModuleAdapter getParsedExtendedSelection() {
        String source = this.normalizeSourceSelection(this.getExtendedSelection());
        if (source.length() > 0) {
            try {
                return VisitorFactory.createModuleAdapter(this.moduleManager, null, (IDocument)new Document(source), this.nature, this.versionProvider);
            }
            catch (TokenMgrError tokenMgrError) {
                return null;
            }
            catch (ParseException parseException) {
                return null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public ModuleAdapter getParsedUserSelection() {
        ModuleAdapter parsedAdapter = null;
        String source = this.normalizeSourceSelection(this.userSelection);
        if (this.userSelection != null && source.length() > 0) {
            try {
                parsedAdapter = VisitorFactory.createModuleAdapter(this.moduleManager, null, (IDocument)new Document(source), this.nature, this.versionProvider);
            }
            catch (TokenMgrError tokenMgrError) {
                return null;
            }
            catch (ParseException parseException) {
                return null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return parsedAdapter;
    }

    public String normalizeSourceSelection(ITextSelection selection) {
        String selectedText = "";
        if (selection.getText() != null) {
            selectedText = selection.getText().trim();
        }
        if (selectedText.length() == 0) {
            return "";
        }
        try {
            return this.normalizeBlockIndentation(selection, selectedText);
        }
        catch (Throwable throwable) {
            return selectedText;
        }
    }

    private String normalizeBlockIndentation(ITextSelection selection, String selectedText) throws Throwable {
        String[] lines = selectedText.split("\\n");
        if (lines.length < 2) {
            return selectedText;
        }
        String firstLine = this.doc.get(this.doc.getLineOffset(selection.getStartLine()), this.doc.getLineLength(selection.getStartLine()));
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
        String indentation = "";
        int bodyIndent = 0;
        while (firstLine.startsWith(" ")) {
            indentation = String.valueOf(indentation) + " ";
            firstLine = firstLine.substring(1);
            ++bodyIndent;
        }
        if (bodyIndent > 0) {
            StringBuffer selectedCode = new StringBuffer();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith(indentation)) {
                    selectedCode.append(String.valueOf(line.substring(bodyIndent)) + lineDelimiter);
                } else {
                    selectedCode.append(String.valueOf(line) + lineDelimiter);
                }
                ++n2;
            }
            selectedText = selectedCode.toString();
        }
        return selectedText;
    }

    public IClassDefAdapter getScopeClass() {
        return this.moduleAdapter.getScopeClass(this.getUserSelection());
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public List<IClassDefAdapter> getScopeClassAndBases() throws MisconfigurationException {
        return this.moduleAdapter.getClassHierarchy(this.getScopeClass());
    }

    public AbstractScopeNode<?> getScopeAdapter() {
        if (this.scopeAdapter == null) {
            this.scopeAdapter = this.moduleAdapter.getScopeAdapter(this.userSelection);
        }
        return this.scopeAdapter;
    }

    public boolean isSelectionExtensionRequired() {
        return this.getUserSelection().getOffset() != this.getExtendedSelection().getOffset() || this.getUserSelection().getLength() != this.getExtendedSelection().getLength();
    }

    public String getNewLineDelim() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
    }

    public AdapterPrefs getAdapterPrefs() {
        return new AdapterPrefs(this.getNewLineDelim(), this.versionProvider);
    }

    public PySelection getPySelection() {
        return new PySelection(this.doc, this.userSelection);
    }

    public IGrammarVersionProvider getVersionProvider() {
        return this.versionProvider;
    }
}

