/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.additionalinfo.IInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.HeuristicFindAttrs;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.ImageCache;

public class AnalysisPlugin
extends AbstractUIPlugin {
    private static AnalysisPlugin plugin;
    private static final Object lock;
    public static Image autoImportClassWithImportType;
    public static Image autoImportMethodWithImportType;
    public static Image autoImportAttributeWithImportType;
    public static Image autoImportModImportType;
    public static Image classWithImportType;
    public static Image methodWithImportType;
    public static Image attributeWithImportType;
    public static Image modImportType;

    static {
        lock = new Object();
    }

    public AnalysisPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static void getDefinitionFromIInfo(List<ItemPointer> pointers, ICodeCompletionASTManager manager, IPythonNature nature, IInfo info, ICompletionCache completionCache) {
        IModule mod = manager.getModule(info.getDeclaringModuleName(), nature, true);
        if (mod != null) {
            if (info.getType() == 5) {
                Definition definition = new Definition(1, 1, "", null, null, mod);
                PyRefactoringFindDefinition.getAsPointers(pointers, (IDefinition[])new Definition[]{definition});
                return;
            }
            String tok = "";
            String path = info.getPath();
            if (path != null && path.length() > 0) {
                tok = String.valueOf(path) + ".";
            }
            tok = String.valueOf(tok) + info.getName();
            try {
                IDefinition[] contextDefinitions;
                IDefinition[] definitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)tok, (IPythonNature)nature, (ICompletionCache)completionCache), -1, -1, nature);
                if ((definitions == null || definitions.length == 0) && path != null && path.length() > 0 && (contextDefinitions = mod.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)path, (IPythonNature)nature, (ICompletionCache)completionCache), -1, -1, nature)) != null && contextDefinitions.length > 0) {
                    IDefinition[] iDefinitionArray = contextDefinitions;
                    int n = contextDefinitions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDefinition iDefinition = iDefinitionArray[n2];
                        if (iDefinition instanceof Definition) {
                            Definition definition = (Definition)iDefinition;
                            if (definition.ast instanceof FunctionDef) {
                                exprType[] args;
                                FunctionDef functionDef = (FunctionDef)definition.ast;
                                if (functionDef.args != null && (args = functionDef.args.args) != null && args.length > 0) {
                                    HashMap repToTokenWithArgs = new HashMap();
                                    HeuristicFindAttrs heuristicFindAttrs = new HeuristicFindAttrs(2, 0, "", definition.module.getName(), null, repToTokenWithArgs);
                                    heuristicFindAttrs.visitFunctionDef(functionDef);
                                    List tokens = heuristicFindAttrs.getTokens();
                                    ArrayList<Definition> newDefs = new ArrayList<Definition>();
                                    for (IToken iToken : tokens) {
                                        if (!info.getName().equals(iToken.getRepresentation())) continue;
                                        newDefs.add(new Definition(iToken, definition.scope, definition.module));
                                    }
                                    definitions = newDefs.toArray(new IDefinition[newDefs.size()]);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                PyRefactoringFindDefinition.getAsPointers(pointers, (IDefinition[])definitions);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static AnalysisPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.python.pydev.analysis", (String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageForAutoImportTypeInfo(IInfo info) {
        switch (info.getType()) {
            case 1: {
                if (autoImportClassWithImportType == null) {
                    Object object = lock;
                    synchronized (object) {
                        ImageCache imageCache = PydevPlugin.getImageCache();
                        autoImportClassWithImportType = imageCache.getImageDecorated("icons/new/class_obj.gif", "icons/new/imp_dec.gif", 1);
                    }
                }
                return autoImportClassWithImportType;
            }
            case 2: {
                if (autoImportMethodWithImportType == null) {
                    Object object = lock;
                    synchronized (object) {
                        ImageCache imageCache = PydevPlugin.getImageCache();
                        autoImportMethodWithImportType = imageCache.getImageDecorated("icons/new/method_obj.gif", "icons/new/imp_dec.gif", 1);
                    }
                }
                return autoImportMethodWithImportType;
            }
            case 3: {
                if (autoImportAttributeWithImportType == null) {
                    Object object = lock;
                    synchronized (object) {
                        ImageCache imageCache = PydevPlugin.getImageCache();
                        autoImportAttributeWithImportType = imageCache.getImageDecorated("icons/new/attrpub_obj.gif", "icons/new/imp_dec.gif", 1);
                    }
                }
                return autoImportAttributeWithImportType;
            }
            case 5: {
                if (autoImportModImportType == null) {
                    Object object = lock;
                    synchronized (object) {
                        ImageCache imageCache = PydevPlugin.getImageCache();
                        autoImportModImportType = imageCache.getImageDecorated("icons/package_obj.gif", "icons/new/imp_dec.gif", 1);
                    }
                }
                return autoImportModImportType;
            }
        }
        throw new RuntimeException("Undefined type.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageForTypeInfo(IInfo info) {
        switch (info.getType()) {
            case 1: {
                if (classWithImportType == null) {
                    Object object = lock;
                    synchronized (object) {
                        ImageCache imageCache = PydevPlugin.getImageCache();
                        classWithImportType = imageCache.get("icons/new/class_obj.gif");
                    }
                }
                return classWithImportType;
            }
            case 2: {
                if (methodWithImportType == null) {
                    Object object = lock;
                    synchronized (object) {
                        ImageCache imageCache = PydevPlugin.getImageCache();
                        methodWithImportType = imageCache.get("icons/new/method_obj.gif");
                    }
                }
                return methodWithImportType;
            }
            case 3: {
                if (attributeWithImportType == null) {
                    Object object = lock;
                    synchronized (object) {
                        ImageCache imageCache = PydevPlugin.getImageCache();
                        attributeWithImportType = imageCache.get("icons/new/attrpub_obj.gif");
                    }
                }
                return attributeWithImportType;
            }
            case 5: {
                if (modImportType == null) {
                    Object object = lock;
                    synchronized (object) {
                        ImageCache imageCache = PydevPlugin.getImageCache();
                        modImportType = imageCache.get("icons/package_obj.gif");
                    }
                }
                return modImportType;
            }
        }
        throw new RuntimeException("Undefined type.");
    }

    public static File getStorageDirForProject(IProject p) {
        IPath location;
        IPath path = location = p.getWorkingLocation(plugin.getBundle().getSymbolicName());
        File file = new File(path.toOSString());
        return file;
    }

    public static String getPluginID() {
        return AnalysisPlugin.getDefault().getBundle().getSymbolicName();
    }
}

