/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.messages.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_ui.utils.PyMarkerUtils;

public class AnalysisRunner {
    public static final String PYDEV_CODE_ANALYSIS_IGNORE = "@PydevCodeAnalysisIgnore";
    public static final String PYDEV_ANALYSIS_TYPE = "PYDEV_TYPE";
    public static final String PYDEV_ANALYSIS_ADDITIONAL_INFO = "PYDEV_INFO";
    public static final String PYDEV_ANALYSIS_PROBLEM_MARKER = "com.python.pydev.analysis.pydev_analysis_problemmarker";
    private static final boolean DEBUG_ANALYSIS_RUNNER = false;

    public boolean canDoAnalysis(IDocument document) {
        if (document == null) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            String line = PySelection.getLine((IDocument)document, (int)i);
            int commentIndex = line.indexOf(35);
            if (commentIndex != -1 && line.substring(commentIndex).contains(PYDEV_CODE_ANALYSIS_IGNORE)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void deleteMarkers(IResource resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers(PYDEV_ANALYSIS_PROBLEM_MARKER, true, 0);
        }
        catch (CoreException e) {
            if (resource.exists()) {
                Log.log((Throwable)e);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void setMarkers(IResource resource, IDocument document, IMessage[] messages, IProgressMonitor monitor) {
        if (resource == null) {
            return;
        }
        try {
            ArrayList<PyMarkerUtils.MarkerInfo> lst = this.generateMarkers(document, messages, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            PyMarkerUtils.replaceMarkers(lst, (IResource)resource, (String)PYDEV_ANALYSIS_PROBLEM_MARKER, (boolean)true, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Log.log((String)("Error when setting markers on: " + resource), (Throwable)e);
        }
    }

    public ArrayList<PyMarkerUtils.MarkerInfo> generateMarkers(IDocument document, IMessage[] messages, IProgressMonitor monitor) {
        ArrayList<PyMarkerUtils.MarkerInfo> lst = new ArrayList<PyMarkerUtils.MarkerInfo>();
        IMessage[] iMessageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            IMessage m = iMessageArray[n2];
            HashMap<String, Object> additionalInfo = new HashMap<String, Object>();
            additionalInfo.put(PYDEV_ANALYSIS_TYPE, m.getType());
            List<String> infoForType = m.getAdditionalInfo();
            if (infoForType != null) {
                additionalInfo.put(PYDEV_ANALYSIS_ADDITIONAL_INFO, infoForType);
            }
            int startLine = m.getStartLine(document) - 1;
            int startCol = m.getStartCol(document) - 1;
            int endLine = m.getEndLine(document) - 1;
            int endCol = m.getEndCol(document) - 1;
            String msg = m.getMessage();
            if (monitor.isCanceled()) {
                return null;
            }
            PyMarkerUtils.MarkerInfo markerInfo = new PyMarkerUtils.MarkerInfo(document, msg, PYDEV_ANALYSIS_PROBLEM_MARKER, m.getSeverity(), false, false, startLine, startCol, endLine, endCol, additionalInfo);
            lst.add(markerInfo);
            ++n2;
        }
        return lst;
    }
}

