/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ctrl_1;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.CtxInsensitiveImportComplProposal;
import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.ctrl_1.IAnalysisMarkersParticipant;
import com.python.pydev.analysis.ui.AutoImportsPreferencesPage;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.ImageCache;

public class UndefinedVariableFixParticipant
implements IAnalysisMarkersParticipant {
    private boolean forceReparseOnApply;

    public UndefinedVariableFixParticipant() {
        this(true);
    }

    public UndefinedVariableFixParticipant(boolean forceReparseOnApply) {
        this.forceReparseOnApply = forceReparseOnApply;
    }

    @Override
    public void addProps(MarkerAnnotationAndPosition markerAnnotation, IAnalysisPreferences analysisPreferences, String line, PySelection ps, int offset, IPythonNature nature, PyEdit edit, List<ICompletionProposal> props) throws BadLocationException, CoreException {
        List<AbstractAdditionalTokensInfo> additionalInfo;
        IMarker marker = markerAnnotation.markerAnnotation.getMarker();
        Integer id = (Integer)marker.getAttribute("PYDEV_TYPE");
        if (id != 3) {
            return;
        }
        if (nature == null) {
            return;
        }
        ICodeCompletionASTManager astManager = nature.getAstManager();
        if (astManager == null) {
            return;
        }
        if (markerAnnotation.position == null) {
            return;
        }
        int start = markerAnnotation.position.offset;
        int end = start + markerAnnotation.position.length;
        ps.setSelection(start, end);
        String markerContents = ps.getSelectedText();
        String fullRep = ps.getFullRepAfterSelection();
        ImageCache imageCache = PydevPlugin.getImageCache();
        Image packageImage = null;
        if (imageCache != null) {
            packageImage = imageCache.get("icons/package_obj.gif");
        }
        IModulesManager projectModulesManager = astManager.getModulesManager();
        Set allModules = projectModulesManager.getAllModuleNames(true, markerContents.toLowerCase());
        HashSet<Tuple<String, String>> mods = new HashSet<Tuple<String, String>>();
        FastStringBuffer buffer = new FastStringBuffer();
        boolean doIgnoreImportsStartingWithUnder = AutoImportsPreferencesPage.doIgnoreImportsStartingWithUnder();
        for (String completeName : allModules) {
            FullRepIterable iterable = new FullRepIterable(completeName);
            for (String mod : iterable) {
                String displayString;
                String realImportRep;
                if (fullRep.startsWith(mod) && (fullRep.length() == mod.length() || fullRep.length() > mod.length() && fullRep.charAt(mod.length()) == '.')) {
                    buffer.clear();
                    String realImportRep2 = buffer.append("import ").append(mod).toString();
                    buffer.clear();
                    String displayString2 = buffer.append("Import ").append(mod).toString();
                    this.addProp(props, realImportRep2, displayString2, packageImage, offset, mods);
                }
                String[] strings = FullRepIterable.headAndTail((String)mod);
                String packageName = strings[0];
                String importRep = strings[1];
                if (!importRep.equals(markerContents)) continue;
                if (packageName.length() > 0) {
                    buffer.clear();
                    realImportRep = buffer.append("from ").append(packageName).append(" ").append("import ").append(strings[1]).toString();
                    buffer.clear();
                    displayString = buffer.append("Import ").append(importRep).append(" (").append(packageName).append(")").toString();
                    this.addProp(props, realImportRep, displayString, packageImage, offset, mods);
                    continue;
                }
                buffer.clear();
                realImportRep = buffer.append("import ").append(strings[1]).toString();
                buffer.clear();
                displayString = buffer.append("Import ").append(importRep).toString();
                this.addProp(props, realImportRep, displayString, packageImage, offset, mods);
            }
        }
        try {
            additionalInfo = AdditionalProjectInterpreterInfo.getAdditionalInfo(nature);
        }
        catch (MisconfigurationException misconfigurationException) {
            return;
        }
        FastStringBuffer tempBuf = new FastStringBuffer();
        for (AbstractAdditionalTokensInfo info : additionalInfo) {
            Collection<IInfo> tokensEqualTo = info.getTokensEqualTo(markerContents, 1);
            for (IInfo found : tokensEqualTo) {
                String name = found.getName();
                String declPackage = found.getDeclaringModuleName();
                String declPackageWithoutInit = declPackage;
                if (declPackageWithoutInit.endsWith(".__init__")) {
                    declPackageWithoutInit = declPackageWithoutInit.substring(0, declPackageWithoutInit.length() - 9);
                }
                declPackageWithoutInit = AutoImportsPreferencesPage.removeImportsStartingWithUnderIfNeeded(declPackageWithoutInit, tempBuf, doIgnoreImportsStartingWithUnder);
                buffer.clear();
                String importDeclaration = buffer.append("from ").append(declPackageWithoutInit).append(" import ").append(name).toString();
                buffer.clear();
                String displayImport = buffer.append("Import ").append(name).append(" (").append(declPackage).append(")").toString();
                this.addProp(props, importDeclaration, displayImport, AnalysisPlugin.getImageForAutoImportTypeInfo(found), offset, mods);
            }
        }
    }

    private void addProp(List<ICompletionProposal> props, String importDeclaration, String displayImport, Image importImage, int offset, Set<Tuple<String, String>> mods) {
        Tuple tuple = new Tuple((Object)importDeclaration, (Object)displayImport);
        if (mods.contains(tuple)) {
            return;
        }
        mods.add((Tuple<String, String>)tuple);
        String tooltip = String.valueOf(importDeclaration) + "\n\nNote: Hold Ctrl on apply to do local import.";
        props.add((ICompletionProposal)new CtxInsensitiveImportComplProposal("", offset, 0, 0, importImage, displayImport, null, tooltip, -1, importDeclaration){

            public void selected(ITextViewer viewer, boolean smartToggle) {
            }

            @Override
            public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
                PySourceViewer sourceViewer;
                PyEdit edit;
                if ((stateMask & 0x40000) != 0) {
                    this.setAddLocalImport(true);
                }
                super.apply(viewer, trigger, stateMask, offset);
                if (UndefinedVariableFixParticipant.this.forceReparseOnApply && viewer instanceof PySourceViewer && (edit = (sourceViewer = (PySourceViewer)viewer).getEdit()) != null) {
                    edit.getParser().forceReparse(new Object[]{new Tuple((Object)"AnalysisParserObserver:force", (Object)true)});
                }
            }
        });
    }
}

