/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.system_info_builder;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.SystemModulesManager;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.pythonpathconf.IInterpreterInfoBuilder;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class InterpreterInfoBuilder
implements IInterpreterInfoBuilder {
    public IInterpreterInfoBuilder.BuilderResult synchInfoToPythonPath(IProgressMonitor monitor, InterpreterInfo info) {
        IInterpreterInfoBuilder.BuilderResult ret;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
            Log.toLogFile((Object)this, (String)"--- Start run");
        }
        if ((ret = this.checkEarlyReturn(monitor, info)) != IInterpreterInfoBuilder.BuilderResult.OK) {
            return ret;
        }
        PythonPathHelper pythonPathHelper = new PythonPathHelper();
        pythonPathHelper.setPythonPath(info.libs);
        ModulesFoundStructure modulesFound = pythonPathHelper.getModulesFoundStructure(null, monitor);
        ret = this.checkEarlyReturn(monitor, info);
        if (ret != IInterpreterInfoBuilder.BuilderResult.OK) {
            return ret;
        }
        SystemModulesManager modulesManager = (SystemModulesManager)info.getModulesManager();
        PyPublicTreeMap keysFound = ModulesManager.buildKeysFromModulesFound((IProgressMonitor)monitor, (ModulesFoundStructure)modulesFound);
        if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
            Log.toLogFile((Object)this, (String)StringUtils.format((String)"Found: %s modules", (Object[])new Object[]{keysFound.size()}));
        }
        if ((ret = this.checkEarlyReturn(monitor, info)) != IInterpreterInfoBuilder.BuilderResult.OK) {
            return ret;
        }
        IInterpreterManager manager = info.getModulesManager().getInterpreterManager();
        try {
            AbstractAdditionalDependencyInfo additionalSystemInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, info.getExecutableOrJar());
            String[] builtins = info.getBuiltins();
            if (builtins != null) {
                int i = 0;
                while (i < builtins.length) {
                    String name = builtins[i];
                    ModulesKey k = new ModulesKey(name, null);
                    keysFound.put((Object)k, (Object)k);
                    ++i;
                }
            }
            Tuple diffModules = modulesManager.diffModules(keysFound);
            if (((List)diffModules.o1).size() > 0 || ((List)diffModules.o2).size() > 0) {
                if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                    Log.toLogFile((Object)this, (String)StringUtils.format((String)"Diff modules. Added: %s Removed: %s", (Object[])new Object[]{diffModules.o1, diffModules.o2}));
                }
                modulesManager.updateKeysAndSave(keysFound);
            }
            additionalSystemInfo.updateKeysIfNeededAndSave((PyPublicTreeMap<ModulesKey, ModulesKey>)keysFound, info, monitor);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
        }
        if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
            Log.toLogFile((Object)this, (String)"--- End Run");
        }
        return IInterpreterInfoBuilder.BuilderResult.OK;
    }

    private IInterpreterInfoBuilder.BuilderResult checkEarlyReturn(IProgressMonitor monitor, InterpreterInfo info) {
        if (monitor.isCanceled()) {
            if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                Log.toLogFile((Object)this, (String)"Cancelled");
            }
            return IInterpreterInfoBuilder.BuilderResult.ABORTED;
        }
        if (!info.getLoadFinished()) {
            if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                Log.toLogFile((Object)this, (String)"Load not finished (rescheduling)");
            }
            return IInterpreterInfoBuilder.BuilderResult.MUST_SYNCH_LATER;
        }
        return IInterpreterInfoBuilder.BuilderResult.OK;
    }
}

