/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pep8;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.messages.IMessage;
import com.python.pydev.analysis.messages.Message;
import com.python.pydev.analysis.ui.AnalysisPreferencesPage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.jython.IPythonInterpreter;
import org.python.pydev.jython.JythonPlugin;
import org.python.pydev.plugin.JythonModules;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class Pep8Visitor {
    private static final String EXECUTE_PEP8 = "import sys\nargv = ['pep8.py', r'%s'%s]\nsys.argv=argv\n\n\npep8style = pep8.StyleGuide(parse_argv=True, config_file=False)\n\nchecker = pep8.Checker(options=pep8style.options, filename='%s', lines=lines)\n\nif ReportError is None: #Only redefine if it wasn't defined already\n    class ReportError:\n\n        def __init__(self, checker, pep8style, visitor):\n            self.checker = checker\n            self.pep8style = pep8style\n            self.visitor = visitor\n            self.original = checker.report_error\n            checker.report_error = self\n            if not self.pep8style.excluded(self.checker.filename):\n                checker.check_all()\n            #Clear references\n            self.original = None\n            self.checker = None\n            self.pep8style = None\n            self.visitor = None\n            checker.report_error = None\n        \n        def __call__(self, line_number, offset, text, check):\n            code = text[:4]\n            if self.pep8style.options.ignore_code(code):\n                return\n            self.visitor.reportError(line_number, offset, text, check)\n            return self.original(line_number, offset, text, check)\n\nReportError(checker, pep8style, visitor)\nchecker = None #Release checker\npep8style = None #Release pep8style\n";
    private final List<IMessage> messages = new ArrayList<IMessage>();
    private IAnalysisPreferences prefs;
    private IDocument document;
    private static volatile PyObject reportError;
    private static final Object lock;
    private String messageToIgnore;

    static {
        lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMessage> getMessages(SourceModule module, IDocument document, IProgressMonitor monitor, IAnalysisPreferences prefs) {
        block15: {
            try {
                if (prefs.getSeverityForType(15) < 1) {
                    return this.messages;
                }
                this.prefs = prefs;
                this.document = document;
                this.messageToIgnore = prefs.getRequiredMessageToIgnore(15);
                File pep8Loc = JythonModules.getPep8Location();
                if (pep8Loc == null) {
                    Log.log((String)"Unable to get pep8 module.");
                    return this.messages;
                }
                if (AnalysisPreferencesPage.useSystemInterpreter()) {
                    String parameters = AnalysisPreferencesPage.getPep8CommandLineAsStr();
                    String output = PyFormatStd.runWithPep8BaseScript((String)document.get(), (String)parameters, (String)"pep8.py", (String)"");
                    List splitInLines = StringUtils.splitInLines((String)output, (boolean)false);
                    for (String line : splitInLines) {
                        try {
                            List lst = StringUtils.split((String)line, (char)':', (int)4);
                            int lineNumber = Integer.parseInt((String)lst.get(1));
                            int offset = Integer.parseInt((String)lst.get(2));
                            String text = (String)lst.get(3);
                            this.reportError(lineNumber, offset, text, null);
                        }
                        catch (Exception e) {
                            Log.log((String)("Error parsing line: " + line), (Throwable)e);
                        }
                    }
                    return this.messages;
                }
                String[] pep8CommandLine = AnalysisPreferencesPage.getPep8CommandLine();
                FastStringBuffer args = new FastStringBuffer(pep8CommandLine.length * 20);
                String[] e = pep8CommandLine;
                int n = pep8CommandLine.length;
                int line = 0;
                while (line < n) {
                    String string = e[line];
                    args.append(',').append("r'").append(string).append('\'');
                    ++line;
                }
                boolean useConsole = AnalysisPreferencesPage.useConsole();
                IPythonInterpreter interpreter = JythonPlugin.newPythonInterpreter((boolean)useConsole, (boolean)false);
                String file = StringUtils.replaceAllSlashes((String)module.getFile().getAbsolutePath());
                interpreter.set("visitor", (Object)this);
                List splitInLines = StringUtils.splitInLines((String)document.get());
                interpreter.set("lines", (Object)splitInLines);
                PyObject tempReportError = reportError;
                if (tempReportError != null) {
                    interpreter.set("ReportError", (Object)tempReportError);
                } else {
                    interpreter.set("ReportError", (Object)Py.None);
                }
                PyObject pep8Module = JythonModules.getPep8Module((IPythonInterpreter)interpreter);
                interpreter.set("pep8", (Object)pep8Module);
                String formatted = StringUtils.format((String)EXECUTE_PEP8, (Object[])new Object[]{file, args.toString(), file});
                interpreter.exec(formatted);
                if (reportError != null) break block15;
                Object object = lock;
                synchronized (object) {
                    if (reportError == null) {
                        reportError = interpreter.get("ReportError");
                    }
                }
            }
            catch (Exception e) {
                Log.log((String)("Error analyzing: " + module), (Throwable)e);
            }
        }
        return this.messages;
    }

    public void reportError(int lineNumber, int offset, String text, Object check) {
        int startLine;
        String line;
        int len;
        try {
            len = this.document.getLineLength(lineNumber - 1);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        if (this.messageToIgnore != null && (line = PySelection.getLine((IDocument)this.document, (int)(startLine = lineNumber - 1))).indexOf(this.messageToIgnore) != -1) {
            return;
        }
        this.messages.add(new Message(15, text, lineNumber, lineNumber, offset + 1, len, this.prefs));
    }
}

