/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.actions;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class LineUncommentAction {
    private TextSelectionUtils ps;
    private String commentPattern;
    private int spacesInStart;

    public LineUncommentAction(TextSelectionUtils ps, String commentPattern, int spacesInStart) {
        this.ps = ps;
        this.commentPattern = commentPattern;
        this.spacesInStart = spacesInStart;
    }

    public FastStringBuffer uncommentLines(String selectedText) {
        List<String> ret = StringUtils.splitInLines(selectedText);
        FastStringBuffer strbuf = new FastStringBuffer(selectedText.length() + ret.size() * 2);
        String spacesInStartComment = "";
        if (this.spacesInStart > 0) {
            spacesInStartComment = StringUtils.createSpaceString(this.spacesInStart);
        }
        String expectedStart = String.valueOf(this.commentPattern) + spacesInStartComment;
        boolean allStartWithSpaces = true;
        for (String string : ret) {
            if (StringUtils.leftTrim(string).startsWith(expectedStart)) continue;
            expectedStart = this.commentPattern;
            allStartWithSpaces = false;
            break;
        }
        int expectedStartLength = expectedStart.length();
        if (allStartWithSpaces) {
            for (String line : ret) {
                int i = line.indexOf(expectedStart);
                strbuf.append(line.substring(0, i));
                strbuf.append(line.substring(i + expectedStartLength));
            }
        } else {
            for (String line : ret) {
                if (StringUtils.leftTrim(line).startsWith(expectedStart)) {
                    int i = line.indexOf(expectedStart);
                    strbuf.append(line.substring(0, i));
                    strbuf.append(line.substring(i + expectedStartLength));
                    continue;
                }
                strbuf.append(line);
            }
        }
        return strbuf;
    }

    public Tuple<Integer, Integer> execute() throws BadLocationException {
        this.ps.selectCompleteLine();
        String selectedText = this.ps.getSelectedText();
        FastStringBuffer strbuf = this.uncommentLines(selectedText);
        ITextSelection txtSel = this.ps.getTextSelection();
        int start = txtSel.getOffset();
        int len = txtSel.getLength();
        String replacement = strbuf.toString();
        this.ps.getDoc().replace(start, len, replacement);
        return new Tuple<Integer, Integer>(start, replacement.length());
    }
}

