/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.auto_edit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.python.pydev.shared_core.auto_edit.AutoEditPairMatcher;
import org.python.pydev.shared_core.auto_edit.IIndentationStringProvider;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class AutoEditStrategyBackspaceHelper {
    private int dontEraseMoreThan = -1;
    private IIndentationStringProvider indentationStringProvider;

    protected int getLastCharPosition(IDocument doc, int cursorOffset) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(cursorOffset);
        int offset = region.getOffset();
        String src = doc.get(offset, region.getLength());
        int i = src.length();
        boolean breaked = false;
        while (i > 0) {
            if (Character.isWhitespace(src.charAt(--i)) || src.charAt(i) == '\t') continue;
            breaked = true;
            break;
        }
        if (!breaked) {
            --i;
        }
        return offset + i;
    }

    public void perform(TextSelectionUtils ps) {
        try {
            IRegion lastCharRegion;
            ITextSelection textSelection = ps.getTextSelection();
            if (textSelection.getLength() != 0) {
                this.eraseSelection(ps);
                return;
            }
            int lastCharPosition = this.getLastCharPosition(ps.getDoc(), ps.getLineOffset());
            int cursorOffset = textSelection.getOffset();
            if (cursorOffset == (lastCharRegion = ps.getDoc().getLineInformationOfOffset(lastCharPosition + 1)).getOffset()) {
                if (cursorOffset != 0) {
                    this.eraseLineDelimiter(ps);
                }
            } else if (cursorOffset <= lastCharPosition) {
                this.eraseToPreviousIndentation(ps, false, lastCharRegion);
            } else if (lastCharRegion.getOffset() == lastCharPosition + 1) {
                this.eraseToPreviousIndentation(ps, true, lastCharRegion);
            } else if (cursorOffset - lastCharPosition == 1) {
                this.eraseSingleChar(ps);
            } else if (cursorOffset - lastCharPosition > 1) {
                this.eraseUntilLastChar(ps, lastCharPosition);
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    private void eraseToPreviousIndentation(TextSelectionUtils ps, boolean hasOnlyWhitespaces, IRegion lastCharRegion) throws BadLocationException {
        String lineContentsToCursor = ps.getLineContentsToCursor();
        if (hasOnlyWhitespaces) {
            this.eraseToIndentation(ps, lineContentsToCursor);
        } else if (TextSelectionUtils.containsOnlyWhitespaces(lineContentsToCursor)) {
            this.eraseToIndentation(ps, lineContentsToCursor);
        } else {
            this.eraseSingleChar(ps);
        }
    }

    private void eraseSingleChar(TextSelectionUtils ps) throws BadLocationException {
        ITextSelection textSelection = ps.getTextSelection();
        int replaceLength = 1;
        int replaceOffset = textSelection.getOffset() - replaceLength;
        IDocument doc = ps.getDoc();
        String contentType = doc.getContentType(replaceOffset);
        if (replaceOffset >= 0 && replaceOffset + replaceLength < doc.getLength()) {
            char c = doc.getChar(replaceOffset);
            if (c == '(' || c == '[' || c == '{' || c == '<') {
                char c2;
                char peer = StringUtils.getPeer(c);
                if (replaceOffset + replaceLength < doc.getLength() && (c2 = doc.getChar(replaceOffset + 1)) == peer) {
                    AutoEditPairMatcher pairMatcher = new AutoEditPairMatcher(new char[]{c, peer}, contentType);
                    int openingPeerOffset = pairMatcher.searchForAnyOpeningPeer(replaceOffset, doc);
                    if (openingPeerOffset == -1) {
                        ++replaceLength;
                    } else {
                        int closingPeerOffset = pairMatcher.searchForClosingPeer(openingPeerOffset + 1, c, peer, doc);
                        if (closingPeerOffset != -1) {
                            ++replaceLength;
                        }
                    }
                }
            } else if (c == '\'' || c == '\"') {
                Tuple<String, String> beforeAndAfterMatchingChars = ps.getBeforeAndAfterMatchingChars(c);
                int matchesBefore = ((String)beforeAndAfterMatchingChars.o1).length();
                int matchesAfter = ((String)beforeAndAfterMatchingChars.o2).length();
                if (matchesBefore == 1 && matchesBefore == matchesAfter) {
                    ++replaceLength;
                }
            }
        }
        this.makeDelete(doc, replaceOffset, replaceLength);
    }

    private void eraseLineDelimiter(TextSelectionUtils ps) throws BadLocationException {
        ITextSelection textSelection = ps.getTextSelection();
        int length = TextSelectionUtils.getDelimiter(ps.getDoc()).length();
        int offset = textSelection.getOffset() - length;
        this.makeDelete(ps.getDoc(), offset, length);
    }

    private void eraseSelection(TextSelectionUtils ps) throws BadLocationException {
        ITextSelection textSelection = ps.getTextSelection();
        this.makeDelete(ps.getDoc(), textSelection.getOffset(), textSelection.getLength());
    }

    private void eraseUntilLastChar(TextSelectionUtils ps, int lastCharPosition) throws BadLocationException {
        ITextSelection textSelection = ps.getTextSelection();
        int cursorOffset = textSelection.getOffset();
        int offset = lastCharPosition + 1;
        int length = cursorOffset - lastCharPosition - 1;
        this.makeDelete(ps.getDoc(), offset, length);
    }

    private void eraseToIndentation(TextSelectionUtils ps, String lineContentsToCursor) throws BadLocationException {
        int replaceLength;
        int replaceOffset;
        char c;
        int cursorOffset = ps.getAbsoluteCursorOffset();
        int lineContentsToCursorLen = lineContentsToCursor.length();
        if (lineContentsToCursorLen > 0 && (c = lineContentsToCursor.charAt(lineContentsToCursorLen - 1)) == '\t') {
            this.eraseSingleChar(ps);
            return;
        }
        String indentationString = this.indentationStringProvider.getIndentationString();
        int indentationLength = indentationString.length();
        int modLen = lineContentsToCursorLen % indentationLength;
        if (modLen == 0) {
            replaceOffset = cursorOffset - indentationLength;
            replaceLength = indentationLength;
        } else {
            replaceOffset = cursorOffset - modLen;
            replaceLength = modLen;
        }
        IDocument doc = ps.getDoc();
        if (replaceLength > 1) {
            String strToReplace = doc.get(replaceOffset, replaceLength);
            char prev = '\u0000';
            int i = strToReplace.length() - 1;
            while (i >= 0) {
                char c2 = strToReplace.charAt(i);
                if (prev != '\u0000' && c2 != prev) {
                    replaceOffset += i + 1;
                    replaceLength -= i + 1;
                    break;
                }
                prev = c2;
                --i;
            }
        }
        this.makeDelete(doc, replaceOffset, replaceLength);
    }

    private void makeDelete(IDocument doc, int replaceOffset, int replaceLength) throws BadLocationException {
        if (replaceOffset < this.dontEraseMoreThan) {
            int delta = this.dontEraseMoreThan - replaceOffset;
            replaceOffset = this.dontEraseMoreThan;
            if ((replaceLength -= delta) <= 0) {
                return;
            }
        }
        doc.replace(replaceOffset, replaceLength, "");
    }

    public void setDontEraseMoreThan(int offset) {
        this.dontEraseMoreThan = offset;
    }

    public static VerifyKeyListener createVerifyKeyListener(final TextViewer viewer, final IIndentationStringProvider indentationStringProvider) {
        return new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.doit && event.character == '\b' && event.stateMask == 0 && viewer != null && viewer.isEditable()) {
                    ISelection selection;
                    boolean blockSelection = false;
                    try {
                        blockSelection = viewer.getTextWidget().getBlockSelection();
                    }
                    catch (Throwable throwable) {}
                    if (!blockSelection && (selection = viewer.getSelection()) instanceof ITextSelection) {
                        AutoEditStrategyBackspaceHelper pyBackspace = new AutoEditStrategyBackspaceHelper();
                        pyBackspace.setIndentationStringProvider(indentationStringProvider);
                        TextSelectionUtils ps = new TextSelectionUtils(viewer.getDocument(), (ITextSelection)selection);
                        pyBackspace.perform(ps);
                        event.doit = false;
                    }
                }
            }
        };
    }

    protected void setIndentationStringProvider(IIndentationStringProvider indentationStringProvider) {
        this.indentationStringProvider = indentationStringProvider;
    }
}

