/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.python.pydev.shared_core.parsing.ScopeEntry;
import org.python.pydev.shared_core.string.BaseParsingUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;

public class Scopes {
    public static int TYPE_COMMENT = 1;
    public static final int TYPE_PEER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_MODULE = 4;
    public static final int TYPE_SUITE = 5;
    private Map<Integer, List<ScopeEntry>> offsetToEntries = new HashMap<Integer, List<ScopeEntry>>();
    private int scopeId = 0;
    private Map<Integer, Tuple<ScopeEntry, ScopeEntry>> idToStartEnd = new HashMap<Integer, Tuple<ScopeEntry, ScopeEntry>>();

    private List<ScopeEntry> getAtOffset(int offset) {
        List<ScopeEntry> list = this.offsetToEntries.get(offset);
        if (list == null) {
            list = new ArrayList<ScopeEntry>();
            this.offsetToEntries.put(offset, list);
        }
        return list;
    }

    public IRegion getScopeForSelection(int offset, int len) {
        int endOffset = offset + len - 1;
        int i = offset;
        while (i >= 0) {
            List<ScopeEntry> list = this.offsetToEntries.get(i);
            if (list != null) {
                ListIterator<ScopeEntry> listIterator = list.listIterator(list.size());
                while (listIterator.hasPrevious()) {
                    ScopeEntry scopeEntry = listIterator.previous();
                    if (!scopeEntry.open) continue;
                    Tuple<ScopeEntry, ScopeEntry> tup = this.idToStartEnd.get(scopeEntry.id);
                    if (i == offset && endOffset == ((ScopeEntry)tup.o2).offset || endOffset > ((ScopeEntry)tup.o2).offset) continue;
                    return new Region(((ScopeEntry)tup.o1).offset, ((ScopeEntry)tup.o2).offset - ((ScopeEntry)tup.o1).offset + 1);
                }
            }
            --i;
        }
        return null;
    }

    public int startScope(int offset, int type) {
        ++this.scopeId;
        List<ScopeEntry> list = this.getAtOffset(offset);
        ScopeEntry startEntry = new ScopeEntry(this.scopeId, type, true, offset);
        list.add(startEntry);
        this.idToStartEnd.put(this.scopeId, new Tuple<ScopeEntry, Object>(startEntry, null));
        return this.scopeId;
    }

    public void endScope(int id, int offset, int type) {
        List<ScopeEntry> list = this.getAtOffset(--offset);
        ScopeEntry endEntry = new ScopeEntry(id, type, false, offset);
        this.idToStartEnd.get((Object)Integer.valueOf((int)id)).o2 = endEntry;
        list.add(endEntry);
    }

    public FastStringBuffer debugString(Object doc) {
        BaseParsingUtils utils = BaseParsingUtils.create(doc);
        FastStringBuffer temp = new FastStringBuffer(utils.len() + utils.len() / 10);
        int len = utils.len();
        int i = 0;
        while (i < len) {
            char c = utils.charAt(i);
            this.printEntries(temp, i, true);
            temp.append(c);
            this.printEntries(temp, i, false);
            ++i;
        }
        return temp;
    }

    private void printEntries(FastStringBuffer temp, int i, boolean opening) {
        List<ScopeEntry> list = this.offsetToEntries.get(i);
        if (list != null) {
            for (ScopeEntry e : list) {
                if (e.open != opening) continue;
                e.toString(temp);
            }
        }
    }
}

