/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.partitioner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;

public class PartitionMerger {
    public static List<TypedPosition> sortAndMergePositions(Position[] positions, int docLen) {
        Arrays.sort(positions, new PositionComparator());
        ArrayList<TypedPosition> lst = new ArrayList<TypedPosition>(positions.length);
        int lastOffset = 0;
        TypedPosition last = null;
        int j = 0;
        while (j < positions.length) {
            Position position = positions[j];
            if (position instanceof TypedPosition) {
                TypedPosition newPos;
                TypedPosition typedPosition = (TypedPosition)position;
                String type = typedPosition.getType();
                int currOffset = typedPosition.getOffset();
                int currLen = typedPosition.getLength();
                if (lastOffset < currOffset) {
                    if (last != null && last.getType().equals("__dftl_partition_content_type")) {
                        last.setLength(last.getLength() + currOffset - lastOffset);
                    } else {
                        newPos = new TypedPosition(lastOffset, currOffset - lastOffset, "__dftl_partition_content_type");
                        lst.add(newPos);
                        last = newPos;
                    }
                }
                if (last != null && last.getType().equals(type)) {
                    last.setLength(last.getLength() + currLen);
                } else {
                    newPos = new TypedPosition(currOffset, currLen, type);
                    lst.add(newPos);
                    last = newPos;
                }
                lastOffset = currOffset + currLen;
            }
            ++j;
        }
        if (lastOffset < docLen) {
            if (last != null && last.getType().equals("__dftl_partition_content_type")) {
                last.setLength(last.getLength() + docLen - lastOffset);
            } else {
                lst.add(new TypedPosition(lastOffset, docLen - lastOffset, "__dftl_partition_content_type"));
            }
        }
        return lst;
    }

    private static final class PositionComparator
    implements Comparator<Position> {
        private PositionComparator() {
        }

        @Override
        public int compare(Position o1, Position o2) {
            return o1.offset - o2.offset;
        }
    }
}

