/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public final class FastStringBuffer
implements CharSequence {
    private char[] value;
    private int count;

    public FastStringBuffer() {
        this(128);
    }

    public FastStringBuffer(int initialSize) {
        this.value = new char[initialSize];
        this.count = 0;
    }

    public FastStringBuffer(char[] internalBuffer) {
        this.value = internalBuffer;
        this.count = internalBuffer.length;
    }

    public void clearMemory() {
        if (this.value.length > 128) {
            this.value = null;
            this.value = new char[128];
        }
        this.count = 0;
    }

    public FastStringBuffer(String s, int additionalSize) {
        this.count = s.length();
        if (additionalSize < 0) {
            additionalSize = 0;
        }
        this.value = new char[this.count + additionalSize];
        s.getChars(0, this.count, this.value, 0);
    }

    public FastStringBuffer append(String string) {
        int strLen = string.length();
        int newCount = this.count + strLen;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        string.getChars(0, strLen, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer appendNoResize(String string) {
        int strLen = string.length();
        string.getChars(0, strLen, this.value, this.count);
        this.count += strLen;
        return this;
    }

    private void resizeForMinimum(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public FastStringBuffer append(int n) {
        String string = String.valueOf(n);
        int strLen = string.length();
        int newCount = this.count + strLen;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        string.getChars(0, strLen, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer append(char n) {
        if (this.count + 1 > this.value.length) {
            int minimumCapacity = this.count + 1;
            int newCapacity = (this.value.length + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        this.value[this.count] = n;
        ++this.count;
        return this;
    }

    public void appendResizeOnExc(char n) {
        try {
            this.value[this.count] = n;
        }
        catch (Exception exception) {
            int minimumCapacity = this.count + 1;
            int newCapacity = (this.value.length + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
            this.value[this.count] = n;
        }
        ++this.count;
    }

    public FastStringBuffer append(long n) {
        String string = String.valueOf(n);
        int strLen = string.length();
        int newCount = this.count + strLen;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        string.getChars(0, strLen, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer append(boolean b) {
        String string = String.valueOf(b);
        int strLen = string.length();
        int newCount = this.count + strLen;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        string.getChars(0, strLen, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer append(double b) {
        String string = String.valueOf(b);
        int strLen = string.length();
        int newCount = this.count + strLen;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        string.getChars(0, strLen, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer append(char[] chars) {
        int newCount = this.count + chars.length;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        System.arraycopy(chars, 0, this.value, this.count, chars.length);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer append(FastStringBuffer other) {
        int len = other.count;
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        System.arraycopy(other.value, 0, this.value, this.count, len);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer append(char[] chars, int offset, int len) {
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        System.arraycopy(chars, offset, this.value, this.count, len);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer reverse() {
        int limit = this.count / 2;
        int i = 0;
        while (i < limit) {
            char c = this.value[i];
            this.value[i] = this.value[this.count - i - 1];
            this.value[this.count - i - 1] = c;
            ++i;
        }
        return this;
    }

    public FastStringBuffer clear() {
        this.count = 0;
        return this;
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public char[] toCharArray() {
        char[] v = new char[this.count];
        System.arraycopy(this.value, 0, v, 0, this.count);
        return v;
    }

    public void deleteLast() {
        if (this.count > 0) {
            --this.count;
        }
    }

    public void deleteLastChars(int charsToDelete) {
        this.count -= charsToDelete;
        if (this.count < 0) {
            this.count = 0;
        }
    }

    public void deleteFirstChars(int charsToDelete) {
        System.arraycopy(this.value, 0 + charsToDelete, this.value, 0, this.count - 0 - charsToDelete);
        this.count -= charsToDelete;
    }

    @Override
    public char charAt(int i) {
        return this.value[i];
    }

    public FastStringBuffer insert(int offset, String str) {
        int len = str.length();
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer insert(int offset, FastStringBuffer str) {
        int len = str.length();
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str.value, 0, this.value, offset, str.count);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer insert(int offset, char c) {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newCount;
        return this;
    }

    public FastStringBuffer appendObject(Object object) {
        String string = object != null ? object.toString() : "null";
        int strLen = string.length();
        int newCount = this.count + strLen;
        if (newCount > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        string.getChars(0, strLen, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer setCount(int newLen) {
        this.count = newLen;
        return this;
    }

    public FastStringBuffer delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public FastStringBuffer replace(int start, int end, String str) {
        int len;
        int newCount;
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (end > this.count) {
            end = this.count;
        }
        if (end > this.count) {
            end = this.count;
        }
        if ((newCount = this.count + (len = str.length()) - (end - start)) > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCount > newCapacity) {
                newCapacity = newCount;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, len, this.value, start);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer replaceAll(String replace, String with) {
        int replaceLen = replace.length();
        int withLen = with.length();
        Assert.isTrue((replaceLen > 0 ? 1 : 0) != 0);
        int matchPos = 0;
        int i = 0;
        while (i < this.count) {
            if (this.value[i] == replace.charAt(matchPos)) {
                if (++matchPos == replaceLen) {
                    this.replace(i - (replaceLen - 1), i + 1, with);
                    matchPos = 0;
                    i -= replaceLen - withLen;
                }
            } else {
                matchPos = 0;
            }
            ++i;
        }
        return this;
    }

    public FastStringBuffer replaceFirst(String replace, String with) {
        int replaceLen = replace.length();
        Assert.isTrue((replaceLen > 0 ? 1 : 0) != 0);
        int matchPos = 0;
        int i = 0;
        while (i < this.count) {
            if (this.value[i] == replace.charAt(matchPos)) {
                if (++matchPos == replaceLen) {
                    this.replace(i - (replaceLen - 1), i + 1, with);
                    return this;
                }
            } else {
                matchPos = 0;
            }
            ++i;
        }
        return this;
    }

    public FastStringBuffer deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public int indexOf(String s) {
        int thisLen = this.length();
        int sLen = s.length();
        int i = 0;
        while (i <= thisLen - sLen) {
            int j = 0;
            while (j < sLen && this.value[i + j] == s.charAt(j)) {
                ++j;
            }
            if (j == sLen) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String s, int fromIndex) {
        int thisLen = this.length();
        int sLen = s.length();
        int i = fromIndex > 0 ? fromIndex : 0;
        while (i <= thisLen - sLen) {
            int j = 0;
            while (j < sLen && this.value[i + j] == s.charAt(j)) {
                ++j;
            }
            if (j == sLen) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(char c) {
        int i = 0;
        while (i < this.count) {
            if (c == this.value[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(char c, int fromOffset) {
        int i = fromOffset;
        while (i < this.count) {
            if (c == this.value[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public char firstChar() {
        return this.value[0];
    }

    public char lastChar() {
        return this.value[this.count - 1];
    }

    public BackwardCharIterator reverseIterator() {
        return new BackwardCharIterator(this);
    }

    public void rightTrim() {
        char c;
        while (this.count > 0 && ((c = this.value[this.count - 1]) == ' ' || c == '\t')) {
            --this.count;
        }
    }

    public char deleteFirst() {
        char ret = this.value[0];
        this.deleteCharAt(0);
        return ret;
    }

    public FastStringBuffer appendN(String val, int n) {
        int strLen = val.length();
        int min = this.count + n * strLen;
        if (min > this.value.length) {
            int newCapacity = (this.value.length + 1) * 2;
            if (min > newCapacity) {
                newCapacity = min;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        while (n-- > 0) {
            val.getChars(0, strLen, this.value, this.count);
            this.count += strLen;
        }
        return this;
    }

    public FastStringBuffer appendN(char val, int n) {
        if (this.count + n > this.value.length) {
            int minimumCapacity = this.count + n;
            int newCapacity = (this.value.length + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
        while (n-- > 0) {
            this.value[this.count] = val;
            ++this.count;
        }
        return this;
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.count - string.length());
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(char c) {
        if (this.count < 1) {
            return false;
        }
        return this.value[0] == c;
    }

    public boolean endsWith(char c) {
        if (this.count < 1) {
            return false;
        }
        return this.value[this.count - 1] == c;
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(String prefix, int offset) {
        ta = this.value;
        to = offset;
        pa = prefix.toCharArray();
        po = 0;
        pc = pa.length;
        if (offset >= 0 && offset <= this.count - pc) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (ta[to++] == pa[po++]) continue;
            return false;
lbl10:
            // 2 sources

            ** while (--pc >= 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    public void setCharAt(int i, char c) {
        this.value[i] = c;
    }

    public void setLength(int i) {
        this.count = i;
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    public int countNewLines() {
        int lines = 0;
        int i = 0;
        while (i < this.count) {
            char c = this.value[i];
            switch (c) {
                case '\n': {
                    ++lines;
                    break;
                }
                case '\r': {
                    ++lines;
                    if (i >= this.count - 1 || this.value[i + 1] != '\n') break;
                    ++i;
                }
            }
            ++i;
        }
        return lines;
    }

    public FastStringBuffer insertN(int pos, char c, int repetitions) {
        FastStringBuffer other = new FastStringBuffer(repetitions);
        other.appendN(c, repetitions);
        this.insert(pos, other);
        return this;
    }

    public String getLastWord() {
        FastStringBuffer lastWordBuf = new FastStringBuffer(this.count);
        int i = this.count - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(this.value[i])) break;
            --i;
        }
        while (i >= 0) {
            if (Character.isWhitespace(this.value[i])) break;
            lastWordBuf.append(this.value[i]);
            --i;
        }
        lastWordBuf.reverse();
        return lastWordBuf.toString();
    }

    public void removeWhitespaces() {
        int length = this.count;
        char[] newVal = new char[length];
        int j = 0;
        int i = 0;
        while (i < length) {
            char ch = this.value[i];
            if (!Character.isWhitespace(ch)) {
                newVal[j] = ch;
                ++j;
            }
            ++i;
        }
        this.count = j;
        this.value = newVal;
    }

    public FastStringBuffer removeChars(Set<Character> chars) {
        int length = this.count;
        char[] newVal = new char[length];
        int j = 0;
        int i = 0;
        while (i < length) {
            char ch = this.value[i];
            if (!chars.contains(Character.valueOf(ch))) {
                newVal[j] = ch;
                ++j;
            }
            ++i;
        }
        this.count = j;
        this.value = newVal;
        return this;
    }

    public char[] getInternalCharsArray() {
        return this.value;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new BufCharSequence(this.value, start, end);
    }

    public static final class BackwardCharIterator
    implements Iterable<Character> {
        private int i;
        private FastStringBuffer fastStringBuffer;

        public BackwardCharIterator(FastStringBuffer fastStringBuffer) {
            this.fastStringBuffer = fastStringBuffer;
            this.i = fastStringBuffer.length();
        }

        @Override
        public Iterator<Character> iterator() {
            return new Iterator<Character>(){

                @Override
                public boolean hasNext() {
                    return BackwardCharIterator.this.i > 0;
                }

                @Override
                public Character next() {
                    char[] cArray = BackwardCharIterator.this.fastStringBuffer.value;
                    BackwardCharIterator backwardCharIterator = BackwardCharIterator.this;
                    int n = backwardCharIterator.i - 1;
                    backwardCharIterator.i = n;
                    return Character.valueOf(cArray[n]);
                }

                @Override
                public void remove() {
                    throw new RuntimeException("Not implemented");
                }
            };
        }
    }

    private static class BufCharSequence
    implements CharSequence {
        private char[] value;
        private int fStart;
        private int fEnd;

        public BufCharSequence(char[] value, int start, int end) {
            this.value = value;
            this.fStart = start;
            this.fEnd = end;
        }

        @Override
        public int length() {
            return this.fEnd - this.fStart;
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.fEnd - this.fStart) {
                throw new IndexOutOfBoundsException();
            }
            return this.value[this.fStart + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new BufCharSequence(this.value, this.fStart + start, this.fStart + end);
        }

        @Override
        public String toString() {
            return new String(this.value, this.fStart, this.fEnd - this.fStart);
        }
    }
}

