/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.structure;

import java.util.Arrays;
import org.python.pydev.shared_core.log.Log;

public final class StringToIntCounterSmallSet {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final int[] EMPTY_INTS = new int[0];
    private String[] strings = EMPTY_STRINGS;
    private int[] ints = EMPTY_INTS;
    private int size;
    private boolean logged;

    public int get(String representation) {
        int i = 0;
        while (i < this.size) {
            if (this.strings[i].equals(representation)) {
                return this.ints[i];
            }
            ++i;
        }
        return 0;
    }

    public int increment(String representation) {
        int i = 0;
        while (i < this.size) {
            if (this.strings[i].equals(representation)) {
                int ret;
                this.ints[i] = ret = this.ints[i] + 1;
                return ret;
            }
            ++i;
        }
        this.put(representation, 1);
        return 1;
    }

    public void put(String representation, int curr) {
        int i = 0;
        while (i < this.size) {
            if (this.strings[i].equals(representation)) {
                this.ints[i] = curr;
                return;
            }
            ++i;
        }
        if (this.strings.length <= this.size) {
            this.strings = Arrays.copyOf(this.strings, this.size + 3);
            this.ints = Arrays.copyOf(this.ints, this.size + 3);
        }
        this.strings[this.size] = representation;
        this.ints[this.size] = curr;
        ++this.size;
        if (this.size > 8 && !this.logged) {
            this.logged = true;
            Log.log("StringToIntCounterSmallSet size > 8 may be big for its use. Consider using a HashMap<String, Integer>.");
        }
    }

    public void clear() {
        this.size = 0;
    }
}

