/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.structure;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.LowMemoryArrayList;

public class TreeNode<T> {
    public T data;
    protected final LowMemoryArrayList<TreeNode> children = new LowMemoryArrayList();
    private Object parent;

    public TreeNode(Object parent, T data) {
        this.parent = parent;
        if (parent instanceof TreeNode) {
            ((TreeNode)parent).addChild(this);
        }
        this.setData(data);
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    private void addChild(TreeNode treeNode) {
        this.children.add(treeNode);
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String toString() {
        return super.toString();
    }

    public String toStringRepr() {
        FastStringBuffer buf = new FastStringBuffer();
        this.fillBuf(this, buf, 0);
        return buf.toString();
    }

    protected void fillBuf(TreeNode<T> treeNode, FastStringBuffer buf, int level) {
        buf.appendN("    ", level).append("TreeNode:").appendObject(treeNode.data).append('\n');
        for (TreeNode child : treeNode.children) {
            this.fillBuf(child, buf, level + 1);
        }
    }

    public <Y> List<TreeNode<Y>> flatten() {
        ArrayList<TreeNode<Y>> array = new ArrayList<TreeNode<Y>>(this.getChildren().size() + 10);
        this.collectChildren(array);
        return array;
    }

    private <Y> void collectChildren(ArrayList<TreeNode<Y>> array) {
        List<TreeNode> c = this.getChildren();
        int size = c.size();
        array.ensureCapacity(array.size() + size);
        int i = 0;
        while (i < size) {
            TreeNode next = c.get(i);
            array.add(next);
            next.collectChildren(array);
            ++i;
        }
    }

    public void clear() {
        this.children.clear();
    }
}

