/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.log.Log;

public class BaseExtensionHelper {
    public static Map<String, List<Object>> testingParticipants;
    private static Map<String, IExtension[]> extensionsCache;

    static {
        extensionsCache = new HashMap<String, IExtension[]>();
    }

    public static IExtension[] getExtensions(String type) {
        IExtension[] extensions = extensionsCache.get(type);
        if (extensions == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry != null) {
                try {
                    IExtensionPoint extensionPoint = registry.getExtensionPoint(type);
                    extensions = extensionPoint.getExtensions();
                    extensionsCache.put(type, extensions);
                }
                catch (Exception e) {
                    Log.log(4, "Error getting extension for:" + type, e);
                    throw new RuntimeException(e);
                }
            } else {
                extensions = new IExtension[]{};
            }
        }
        return extensions;
    }

    public static Object getParticipant(String type, boolean allowOverride) {
        List participants = BaseExtensionHelper.getParticipants(type);
        if (participants.isEmpty()) {
            return null;
        }
        if (!allowOverride && participants.size() > 1) {
            throw new RuntimeException("More than one participant is registered for type:" + type);
        }
        return participants.get(participants.size() - 1);
    }

    public static List getParticipants(String type) {
        List<Object> list = null;
        if (SharedCorePlugin.inTestMode()) {
            if (testingParticipants != null) {
                list = testingParticipants.get(type);
            }
            if (list == null) {
                list = new ArrayList();
            }
            return list;
        }
        list = new ArrayList();
        try {
            IExtension[] iExtensionArray = BaseExtensionHelper.getExtensions(type);
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        list.add(element.createExecutableExtension("class"));
                    }
                    catch (Throwable e) {
                        Log.log(e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (SecurityException securityException) {}
        return list;
    }
}

