/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.eclipse.ui.part.IPageBookViewPage;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.console.ScriptConsoleViewerWrapper;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.GetCompletionsCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.debug.newconsole.PydevConsoleCompletionProcessor;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleShell;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;

public class ConsoleCompletionsPageParticipant
implements IConsolePageParticipant {
    private PyContentAssistant contentAssist;

    protected static PyStackFrame getCurrentSuspendedPyStackFrame(IConsole console) {
        PyStackFrame stackFrame;
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof PyStackFrame && !(stackFrame = (PyStackFrame)context).isTerminated() && stackFrame.isSuspended()) {
            AbstractDebugTarget target;
            if (console != null && DebugUITools.getConsole((IProcess)(target = (AbstractDebugTarget)stackFrame.getAdapter(IDebugTarget.class)).getProcess()) != console) {
                return null;
            }
            return stackFrame;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void init(IPageBookViewPage page, final IConsole console) {
        if (!(console instanceof ProcessConsole)) {
            return;
        }
        ProcessConsole processConsole = (ProcessConsole)console;
        IProcess process = processConsole.getProcess();
        if (process == null) {
            return;
        }
        if (!PyCodeCompletionPreferencesPage.useCodeCompletion() || !PyCodeCompletionPreferencesPage.useCodeCompletionOnDebug()) {
            return;
        }
        String attribute = process.getAttribute("PYDEV_DEBUG_IPROCESS_ATTR");
        if (!"true".equals(attribute)) {
            return;
        }
        Control control = page.getControl();
        if (page instanceof IOConsolePage) {
            control.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (KeyBindingHelper.matchesContentAssistKeybinding((KeyEvent)e)) {
                        ConsoleCompletionsPageParticipant.this.contentAssist.showPossibleCompletions();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            IOConsolePage consolePage = (IOConsolePage)page;
            TextConsoleViewer viewer = consolePage.getViewer();
            this.contentAssist = new PyContentAssistant(){

                public String showPossibleCompletions() {
                    if (ConsoleCompletionsPageParticipant.getCurrentSuspendedPyStackFrame(console) == null) {
                        return null;
                    }
                    return super.showPossibleCompletions();
                }
            };
            this.contentAssist.setInformationControlCreator(PyContentAssistant.createInformationControlCreator((ISourceViewer)viewer));
            ILaunch launch = process.getLaunch();
            IDebugTarget debugTarget = launch.getDebugTarget();
            IInterpreterInfo projectInterpreter = null;
            if (debugTarget instanceof PyDebugTarget) {
                PyDebugTarget pyDebugTarget = (PyDebugTarget)debugTarget;
                PythonNature nature = PythonNature.getPythonNature((IProject)pyDebugTarget.project);
                if (nature != null) {
                    try {
                        projectInterpreter = nature.getProjectInterpreter();
                    }
                    catch (Throwable e1) {
                        Log.log((Throwable)e1);
                    }
                }
            }
            this.contentAssist.install((ITextViewer)new ScriptConsoleViewerWrapper(viewer, projectInterpreter));
            PydevConsoleInterpreter interpreter = new PydevConsoleInterpreter();
            interpreter.setConsoleCommunication(new GetCompletionsInDebug());
            PydevConsoleCompletionProcessor processor = new PydevConsoleCompletionProcessor((IScriptConsoleShell)interpreter, this.contentAssist);
            this.contentAssist.setContentAssistProcessor((IContentAssistProcessor)processor, IOConsolePartition.INPUT_PARTITION_TYPE);
            this.contentAssist.setContentAssistProcessor((IContentAssistProcessor)processor, IOConsolePartition.OUTPUT_PARTITION_TYPE);
            this.contentAssist.enableAutoActivation(true);
            this.contentAssist.enableAutoInsert(false);
            this.contentAssist.setAutoActivationDelay(PyCodeCompletionPreferencesPage.getAutocompleteDelay());
        }
    }

    public void dispose() {
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public static class GetCompletionsInDebug
    implements IScriptConsoleCommunication,
    ICommandResponseListener {
        private static final ICompletionProposal[] EMPTY_COMPLETION_PROPOSALS = new ICompletionProposal[0];
        private ICompletionProposal[] receivedCompletions;
        private String actTok;
        private String text;
        private int offset;

        public String getDescription(String text) throws Exception {
            throw new RuntimeException("Not implemented");
        }

        public ICompletionProposal[] getCompletions(String text, String actTok, int offset, boolean showForTabCompletion) throws Exception {
            this.text = text;
            this.actTok = actTok;
            this.offset = offset;
            PyStackFrame stackFrame = ConsoleCompletionsPageParticipant.getCurrentSuspendedPyStackFrame(null);
            if (stackFrame != null) {
                AbstractDebugTarget target = (AbstractDebugTarget)stackFrame.getAdapter(IDebugTarget.class);
                if (target != null) {
                    GetCompletionsCommand cmd = new GetCompletionsCommand(target, actTok, stackFrame.getLocalsLocator().getPyDBLocation());
                    cmd.setCompletionListener(this);
                    target.postCommand(cmd);
                }
                return this.waitForCommand();
            }
            return EMPTY_COMPLETION_PROPOSALS;
        }

        private ICompletionProposal[] waitForCommand() {
            int i = 300;
            while (--i > 0 && this.receivedCompletions == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ICompletionProposal[] temp = this.receivedCompletions;
            this.receivedCompletions = null;
            if (temp == null) {
                Log.logInfo((String)"Timeout for waiting for debug completions elapsed (3 seconds).");
                return EMPTY_COMPLETION_PROPOSALS;
            }
            return temp;
        }

        public void execInterpreter(String command, ICallback<Object, InterpreterResponse> onResponseReceived) {
            throw new RuntimeException("Not implemented");
        }

        public void interrupt() {
            throw new RuntimeException("Not implemented");
        }

        public void setOnContentsReceivedCallback(ICallback<Object, Tuple<String, String>> onContentsReceived) {
            throw new RuntimeException("Not implemented");
        }

        public void close() throws Exception {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void commandComplete(AbstractDebuggerCommand cmd) {
            GetCompletionsCommand compCmd = (GetCompletionsCommand)cmd;
            try {
                String response = compCmd.getResponse();
                List<Object[]> fromServer = XMLUtils.convertXMLcompletionsFromConsole(response);
                ArrayList<ICompletionProposal> ret = new ArrayList<ICompletionProposal>();
                PydevConsoleCommunication.convertToICompletions(this.text, this.actTok, this.offset, fromServer, ret, false);
                this.receivedCompletions = ret.toArray(new ICompletionProposal[ret.size()]);
            }
            catch (CoreException e) {
                this.receivedCompletions = EMPTY_COMPLETION_PROPOSALS;
                Log.log((Throwable)e);
            }
        }

        public void linkWithDebugSelection(boolean isLinkedWithDebug) {
            throw new RuntimeException("Not implemented");
        }
    }
}

