/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.StringUtils;

public class ConfigureExceptionsFileUtils {
    public static String DELIMITER = ";";

    private ConfigureExceptionsFileUtils() {
    }

    public static void writeToFile(String fileName, String pyExceptionsStr, boolean isAppend) {
        IPath path = ConfigureExceptionsFileUtils.getFilePathFromMetadata(fileName);
        try {
            FileOutputStream fstream = new FileOutputStream(path.toFile(), isAppend);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fstream, "utf-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(pyExceptionsStr);
            bufferedWriter.close();
        }
        catch (IOException e) {
            Log.log((Throwable)e);
        }
    }

    public static String readFromMetadataFile(String fileName) {
        IPath filePathFromWorkSpace = ConfigureExceptionsFileUtils.getFilePathFromMetadata(fileName);
        File file = filePathFromWorkSpace.toFile();
        if (file.exists()) {
            return FileUtils.getFileContentsCustom((File)file, (String)"utf-8", String.class).toString();
        }
        return "";
    }

    public static List<String> getConfiguredExceptions(String fileName) {
        String pyExceptionStr = ConfigureExceptionsFileUtils.readFromMetadataFile(fileName);
        if (pyExceptionStr.length() > 0) {
            return StringUtils.split((String)pyExceptionStr, (String)DELIMITER);
        }
        return new ArrayList<String>();
    }

    public static IPath getFilePathFromMetadata(String fileName) {
        Bundle bundle = Platform.getBundle((String)"org.python.pydev");
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.addTrailingSeparator().append(fileName);
        return path;
    }
}

