/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.curr_exception;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.CaughtException;
import org.python.pydev.debug.model.PyVariable;

public class CurrentExceptionViewContentProvider
implements ITreeContentProvider {
    private final Map<Object, Object> parentCache = new HashMap<Object, Object>();

    public void dispose() {
        this.parentCache.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.parentCache.clear();
    }

    public Object[] getElements(Object inputElement) {
        List elements = (List)inputElement;
        for (IDebugTarget iDebugTarget : elements) {
            this.getChildren(iDebugTarget);
        }
        return elements.toArray(new IDebugTarget[elements.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = this.internalGetChildren(parentElement);
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.parentCache.put(child, parentElement);
                ++n2;
            }
        }
        return children;
    }

    private Object[] internalGetChildren(Object parentElement) {
        if (parentElement instanceof AbstractDebugTarget) {
            AbstractDebugTarget target = (AbstractDebugTarget)parentElement;
            List<CaughtException> currExceptions = target.getCurrExceptions();
            return currExceptions.toArray(new CaughtException[currExceptions.size()]);
        }
        if (parentElement instanceof CaughtException) {
            CaughtException caughtException = (CaughtException)parentElement;
            return caughtException.threadNstack.stack;
        }
        if (parentElement instanceof IThread) {
            IThread pyThread = (IThread)parentElement;
            try {
                return pyThread.getStackFrames();
            }
            catch (DebugException e) {
                Log.log((Throwable)e);
                return null;
            }
        }
        if (parentElement instanceof IStackFrame) {
            IStackFrame iStackFrame = (IStackFrame)parentElement;
            try {
                return iStackFrame.getVariables();
            }
            catch (DebugException e) {
                Log.log((Throwable)e);
                return null;
            }
        }
        if (parentElement instanceof PyVariable) {
            PyVariable pyVariable = (PyVariable)parentElement;
            try {
                return pyVariable.getVariables();
            }
            catch (DebugException e) {
                Log.log((Throwable)e);
                return null;
            }
        }
        Log.log((String)("Unexpected parent: " + parentElement));
        return null;
    }

    public Object getParent(Object element) {
        Object parent = this.parentCache.get(element);
        return parent;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof List) {
            List list = (List)element;
            return list.size() > 0;
        }
        if (element instanceof IValue) {
            try {
                return ((IValue)element).hasVariables();
            }
            catch (DebugException e) {
                Log.log((Throwable)e);
            }
        }
        return true;
    }
}

