/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.ui.IEditorInput;
import org.python.pydev.core.IPyStackFrame;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.shared_ui.EditorUtils;

public class PySourceLocator
implements ISourceLocator,
ISourcePresentation {
    private PySourceLocatorBase locatorBase = new PySourceLocatorBase();
    private IProject lastProject = null;

    public Object getSourceElement(IStackFrame stackFrame) {
        return stackFrame;
    }

    public IEditorInput getEditorInput(Object element) {
        IEditorInput edInput = null;
        if (element instanceof PyStackFrame) {
            PyStackFrame pyStackFrame = (PyStackFrame)element;
            IPath path = pyStackFrame.getPath();
            Object target = pyStackFrame.getAdapter(IDebugTarget.class);
            if (target instanceof PyDebugTarget) {
                this.lastProject = ((PyDebugTarget)target).project;
            }
            if (path != null && !path.toString().startsWith("<")) {
                edInput = this.locatorBase.createEditorInput(path, true, (IPyStackFrame)pyStackFrame, this.lastProject);
            }
        }
        return edInput;
    }

    public String getEditorId(IEditorInput input, Object element) {
        String name = input.getName();
        if (PythonPathHelper.isValidSourceFile((String)name)) {
            return "org.python.pydev.editor.PythonEditor";
        }
        String ret = EditorUtils.getEditorId((IEditorInput)input, (Object)element);
        if (ret == null) {
            ret = "org.python.pydev.editor.PythonEditor";
        }
        return ret;
    }
}

