/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.DeferredWorkbenchAdapter;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyConsoleCodeGeneratorVariable;
import org.python.pydev.debug.model.PyVariableContentProviderHack;
import org.python.pydev.debug.model.remote.ChangeVariableCommand;
import org.python.pydev.shared_interactive_console.console.codegen.IScriptConsoleCodeGenerator;

public class PyVariable
extends PlatformObject
implements IVariable,
IValue,
IVariableLocator {
    protected String name;
    protected String type;
    protected String value;
    protected AbstractDebugTarget target;
    protected boolean isModified;
    protected IVariableLocator locator;
    private static final IVariable[] EMPTY_IVARIABLE_ARRAY = new IVariable[0];
    protected String id;

    public PyVariable(AbstractDebugTarget target, String name, String type, String value, IVariableLocator locator) {
        this.value = value;
        this.name = name;
        this.type = type;
        this.target = target;
        this.locator = locator;
        this.isModified = false;
    }

    public void setRefererrerFoundInfo(String id, String foundAs) {
        if (foundAs != null && foundAs.length() > 0) {
            this.name = String.valueOf(this.name) + " Found as: " + foundAs;
        }
        if (id != null && id.length() > 0) {
            this.id = id;
        }
    }

    @Override
    public String getThreadId() {
        return this.locator.getThreadId();
    }

    @Override
    public String getPyDBLocation() {
        if (this.id == null) {
            return String.valueOf(this.locator.getPyDBLocation()) + "\t" + this.name;
        }
        return String.valueOf(this.locator.getThreadId()) + "\t" + this.id + "\tBY_ID";
    }

    public String getDetailText() throws DebugException {
        return this.getValueString();
    }

    public IValue getValue() throws DebugException {
        return this;
    }

    public String getValueString() throws DebugException {
        if (this.value == null) {
            return "";
        }
        if ("StringType".equals(this.type) || "UnicodeType".equals(this.type)) {
            return "\"" + this.value + "\"";
        }
        return this.value;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getModelIdentifier() {
        return this.target.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public boolean supportsValueModification() {
        return this.locator != null;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.isModified;
    }

    public void setModified(boolean mod) {
        this.isModified = mod;
    }

    public void setValue(String expression) throws DebugException {
        ChangeVariableCommand changeVariableCommand = this.getChangeVariableCommand(this.target, expression);
        this.target.postCommand(changeVariableCommand);
        this.value = expression;
        this.target.fireEvent(new DebugEvent((Object)this, 528));
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public Object getAdapter(Class adapter) {
        AdapterDebug.print(this, adapter);
        if (adapter.equals(ILaunch.class)) {
            return this.target.getAdapter(adapter);
        }
        if (adapter.equals(IRunToLineTarget.class)) {
            return this.target.getRunToLineTarget();
        }
        if (adapter.equals(IScriptConsoleCodeGenerator.class)) {
            return new PyConsoleCodeGeneratorVariable(this);
        }
        if (adapter.equals(IPropertySource.class) || adapter.equals(ITaskListResourceAdapter.class) || adapter.equals(IContributorResourceAdapter.class) || adapter.equals(IActionFilter.class) || adapter.equals(IWorkbenchAdapter.class) || adapter.equals(IToggleBreakpointsTarget.class) || adapter.equals(IResource.class) || adapter.equals(IFile.class)) {
            return super.getAdapter(adapter);
        }
        if (adapter.equals(IDeferredWorkbenchAdapter.class)) {
            return new DeferredWorkbenchAdapter(this);
        }
        if (adapter.toString().endsWith("org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider")) {
            return new PyVariableContentProviderHack();
        }
        AdapterDebug.printDontKnow(this, adapter);
        return super.getAdapter(adapter);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return EMPTY_IVARIABLE_ARRAY;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.type;
    }

    public ChangeVariableCommand getChangeVariableCommand(AbstractDebugTarget dbg, String expression) {
        return new ChangeVariableCommand(dbg, this.getPyDBLocation(), expression);
    }
}

