/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.PyVariable;

public class ValueModificationChecker {
    private Map<String, Map<String, PyStackFrame>> cache = new HashMap<String, Map<String, PyStackFrame>>();
    private Object lock = new Object();

    public void verifyVariablesModified(IVariable[] newFrameVariables, IVariable[] oldVariables) {
        if (oldVariables == null) {
            return;
        }
        PyVariable newVariable = null;
        try {
            HashMap<String, IVariable> map = new HashMap<String, IVariable>();
            IVariable[] iVariableArray = oldVariables;
            int n = oldVariables.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable var = iVariableArray[n2];
                map.put(var.getName(), var);
                ++n2;
            }
            HashMap<String, IVariable> variablesAsMap = map;
            int i = 0;
            while (i < newFrameVariables.length) {
                newVariable = (PyVariable)newFrameVariables[i];
                PyVariable oldVariable = (PyVariable)variablesAsMap.get(newVariable.getName());
                if (oldVariable != null) {
                    boolean equals = newVariable.getValueString().equals(oldVariable.getValueString());
                    newVariable.setModified(!equals);
                } else {
                    newVariable.setModified(true);
                }
                ++i;
            }
        }
        catch (DebugException e) {
            Log.log((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyModified(PyStackFrame frame, IVariable[] newFrameVariables) {
        Object object = this.lock;
        synchronized (object) {
            PyStackFrame cacheFrame;
            Map<String, PyStackFrame> threadIdCache = this.cache.get(frame.getThreadId());
            if (threadIdCache == null) {
                threadIdCache = new HashMap<String, PyStackFrame>();
                this.cache.put(frame.getThreadId(), threadIdCache);
            }
            if ((cacheFrame = threadIdCache.get(frame.getId())) == null) {
                threadIdCache.put(frame.getId(), frame);
                return;
            }
            if (cacheFrame == frame) {
                return;
            }
            this.verifyVariablesModified(newFrameVariables, cacheFrame.getInternalVariables());
            threadIdCache.put(frame.getId(), frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onlyLeaveThreads(PyThread[] threads) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<String> ids = new HashSet<String>();
            PyThread[] pyThreadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                PyThread thread = pyThreadArray[n2];
                ids.add(thread.getId());
                ++n2;
            }
            HashSet<String> keySet = new HashSet<String>(this.cache.keySet());
            for (String id : keySet) {
                if (ids.contains(id)) continue;
                this.cache.remove(id);
            }
        }
    }
}

