/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;

public class DebuggerWriter
implements Runnable {
    private Socket socket;
    private List<AbstractDebuggerCommand> cmdQueue = new ArrayList<AbstractDebuggerCommand>();
    private OutputStreamWriter out;
    private volatile boolean done = false;
    private Object lock = new Object();

    public DebuggerWriter(Socket s) throws IOException {
        this.socket = s;
        this.out = new OutputStreamWriter(s.getOutputStream(), "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommand(AbstractDebuggerCommand cmd) {
        List<AbstractDebuggerCommand> list = this.cmdQueue;
        synchronized (list) {
            this.cmdQueue.add(cmd);
        }
    }

    public void done() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            AbstractDebuggerCommand cmd = null;
            List<AbstractDebuggerCommand> list = this.cmdQueue;
            synchronized (list) {
                if (this.cmdQueue.size() > 0) {
                    cmd = this.cmdQueue.remove(0);
                }
            }
            try {
                Object outgoing;
                if (cmd != null) {
                    block15: {
                        try {
                            outgoing = cmd.getOutgoing();
                            if (outgoing == null) {
                            }
                            break block15;
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                        }
                        continue;
                    }
                    cmd.aboutToSend();
                    this.out.write((String)outgoing);
                    this.out.write("\n");
                    this.out.flush();
                }
                outgoing = this.lock;
                synchronized (outgoing) {
                    Thread.sleep(100L);
                }
            }
            catch (IOException | InterruptedException exception) {
                this.done = true;
            }
            catch (Throwable e1) {
                Log.log((Throwable)e1);
            }
            if (this.socket != null && this.socket.isConnected()) continue;
            this.done = true;
        }
    }
}

