/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.shared_core.structure.Tuple;

public class RunCustomOperationCommand
extends AbstractDebuggerCommand {
    private String encodedCodeOrFile;
    private String operationFnName;
    private IVariableLocator locator;
    private String style;
    private String responsePayload;

    public static Tuple<AbstractDebugTarget, IVariableLocator> extractContextFromSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object elem = structuredSelection.getFirstElement();
            if (elem instanceof PyVariable) {
                PyVariable pyVar = (PyVariable)elem;
                AbstractDebugTarget target = (AbstractDebugTarget)pyVar.getDebugTarget();
                return new Tuple((Object)target, (Object)pyVar);
            }
            if (elem instanceof IWatchExpression) {
                IWatchExpression expression = (IWatchExpression)elem;
                final String expressionText = expression.getExpressionText();
                IDebugTarget debugTarget = expression.getDebugTarget();
                if (debugTarget instanceof AbstractDebugTarget) {
                    AbstractDebugTarget target = (AbstractDebugTarget)debugTarget;
                    IAdaptable context = DebugUITools.getDebugContext();
                    final PyStackFrame stackFrame = (PyStackFrame)context.getAdapter(PyStackFrame.class);
                    if (stackFrame != null) {
                        return new Tuple((Object)target, (Object)new IVariableLocator(){

                            @Override
                            public String getThreadId() {
                                return stackFrame.getThreadId();
                            }

                            @Override
                            public String getPyDBLocation() {
                                String locator = stackFrame.getExpressionLocator().getPyDBLocation();
                                return String.valueOf(locator) + "\t" + expressionText;
                            }
                        });
                    }
                }
            }
        }
        return null;
    }

    private RunCustomOperationCommand(AbstractDebugTarget target, IVariableLocator locator, String style, String codeOrFile, String operationFnName) {
        super(target);
        this.locator = locator;
        this.style = style;
        this.encodedCodeOrFile = RunCustomOperationCommand.encode(codeOrFile);
        this.operationFnName = operationFnName;
    }

    public RunCustomOperationCommand(AbstractDebugTarget target, IVariableLocator locator, String operationSource, String operationFnName) {
        this(target, locator, "EXEC", operationSource, operationFnName);
    }

    public RunCustomOperationCommand(AbstractDebugTarget target, IVariableLocator locator, File operationPyFile, String operationFnName) {
        this(target, locator, "EXECFILE", operationPyFile.toString(), operationFnName);
    }

    @Override
    public String getOutgoing() {
        String payload = String.valueOf(this.locator.getPyDBLocation()) + "||" + this.style + "\t" + this.encodedCodeOrFile + "\t" + this.operationFnName;
        String cmd = RunCustomOperationCommand.makeCommand(135, this.sequence, payload);
        return cmd;
    }

    @Override
    public boolean needResponse() {
        return true;
    }

    @Override
    public void processOKResponse(int cmdCode, String payload) {
        if (cmdCode == 135) {
            this.responsePayload = RunCustomOperationCommand.decode(payload);
        }
    }

    public String getResponsePayload() {
        return this.responsePayload;
    }

    private static String encode(String in) {
        try {
            return URLEncoder.encode(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.log((String)"Unreachable? UTF-8 is always supported.", (Throwable)e);
            return "";
        }
    }

    private static String decode(String in) {
        try {
            return URLDecoder.decode(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.log((String)"Unreachable? UTF-8 is always supported.", (Throwable)e);
            return "";
        }
    }
}

