/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.ImportsSelection;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant2;
import org.python.pydev.editor.codecompletion.PyLinkedModeCompletionProposal;
import org.python.pydev.editor.codecompletion.templates.PyTemplateCompletionProcessor;
import org.python.pydev.editor.simpleassist.ISimpleAssistParticipant2;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleInterpreter;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleViewer;

public class PydevConsoleInterpreter
implements IScriptConsoleInterpreter {
    private IScriptConsoleCommunication consoleCommunication;
    private List<Runnable> closeRunnables = new ArrayList<Runnable>();
    private List<ISimpleAssistParticipant2> simpleParticipants;
    private List<IPythonNature> naturesUsed = new ArrayList<IPythonNature>();
    private IInterpreterInfo interpreterInfo;
    private PyStackFrame frame;
    private ILaunch launch;
    private Process process;

    public PydevConsoleInterpreter() {
        List p = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_simpleassist");
        ArrayList<ISimpleAssistParticipant2> list = new ArrayList<ISimpleAssistParticipant2>();
        for (Object o : p) {
            if (!(o instanceof ISimpleAssistParticipant2)) continue;
            list.add((ISimpleAssistParticipant2)o);
        }
        this.simpleParticipants = list;
    }

    public void setOnContentsReceivedCallback(ICallback<Object, Tuple<String, String>> onContentsReceived) {
        this.consoleCommunication.setOnContentsReceivedCallback(onContentsReceived);
    }

    public void exec(String command, ICallback<Object, InterpreterResponse> onResponseReceived) {
        this.consoleCommunication.execInterpreter(command, onResponseReceived);
    }

    public void interrupt() {
        this.consoleCommunication.interrupt();
    }

    public void setFrame(PyStackFrame frame) throws Exception {
        this.frame = frame;
    }

    public ICompletionProposal[] getCompletions(IScriptConsoleViewer viewer, String commandLine, int position, int offset, int whatToShow) throws Exception {
        String text = commandLine.substring(0, position);
        PySelection.ActivationTokenAndQual tokenAndQual = PySelection.getActivationTokenAndQual((IDocument)new Document(text), (int)text.length(), (boolean)true, (boolean)false);
        ICodeCompletionASTManager.ImportInfo importsTipper = ImportsSelection.getImportsTipperStr((String)text, (boolean)false);
        if (importsTipper.importsTipperStr.length() != 0) {
            importsTipper.importsTipperStr = importsTipper.importsTipperStr.trim();
            TreeSet<IToken> tokens = new TreeSet<IToken>();
            boolean onlyGetDirectModules = false;
            for (final IPythonNature nature : this.naturesUsed) {
                ICodeCompletionASTManager astManager = nature.getAstManager();
                IToken[] importTokens = astManager.getCompletionsForImport(importsTipper, new ICompletionRequest(){

                    public IPythonNature getNature() {
                        return nature;
                    }

                    public File getEditorFile() {
                        return null;
                    }

                    public IModule getModule() throws MisconfigurationException {
                        return null;
                    }
                }, onlyGetDirectModules);
                onlyGetDirectModules = true;
                tokens.addAll(Arrays.asList(importTokens));
            }
            int qlen = tokenAndQual.qualifier.length();
            ArrayList<PyLinkedModeCompletionProposal> ret = new ArrayList<PyLinkedModeCompletionProposal>(tokens.size());
            Iterator it = tokens.iterator();
            int i = 0;
            while (i < tokens.size()) {
                IToken t = (IToken)it.next();
                int replacementOffset = offset - qlen;
                String representation = t.getRepresentation();
                if (representation.startsWith(tokenAndQual.qualifier)) {
                    ret.add(new PyLinkedModeCompletionProposal(representation, replacementOffset, qlen, representation.length(), t, null, null, 10, 1, ""));
                }
                ++i;
            }
            return ret.toArray(new ICompletionProposal[ret.size()]);
        }
        String actTok = tokenAndQual.activationToken;
        if (tokenAndQual.qualifier != null && tokenAndQual.qualifier.length() > 0) {
            if (actTok.length() > 0 && actTok.charAt(actTok.length() - 1) != '.') {
                actTok = String.valueOf(actTok) + '.';
            }
            actTok = String.valueOf(actTok) + tokenAndQual.qualifier;
        }
        boolean showOnlyTemplates = whatToShow == 2;
        boolean showForTabCompletion = whatToShow == 3;
        ArrayList results = new ArrayList();
        if (!showForTabCompletion) {
            for (ISimpleAssistParticipant2 participant : this.simpleParticipants) {
                results.addAll(participant.computeConsoleProposals(tokenAndQual.activationToken, tokenAndQual.qualifier, offset));
            }
        }
        ArrayList<ICompletionProposal> results2 = new ArrayList<ICompletionProposal>();
        if (!showOnlyTemplates && this.consoleCommunication != null) {
            ICompletionProposal[] consoleCompletions = this.consoleCommunication.getCompletions(text, actTok, offset, showForTabCompletion);
            if (showForTabCompletion) {
                return consoleCompletions;
            }
            results2.addAll(Arrays.asList(consoleCompletions));
        }
        if (tokenAndQual.activationToken.length() == 0) {
            PyTemplateCompletionProcessor pyTemplateCompletionProcessor = new PyTemplateCompletionProcessor();
            pyTemplateCompletionProcessor.addTemplateProposals((ITextViewer)viewer, offset, results2);
        }
        Collections.sort(results2, IPyCodeCompletion.PROPOSAL_COMPARATOR);
        ArrayList results3 = new ArrayList();
        if (!showOnlyTemplates) {
            List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
            for (Object participant : participants) {
                if (!(participant instanceof IPyDevCompletionParticipant2)) continue;
                IPyDevCompletionParticipant2 participant2 = (IPyDevCompletionParticipant2)participant;
                results3.addAll(participant2.computeConsoleCompletions(tokenAndQual, this.naturesUsed, viewer, offset));
            }
            Collections.sort(results3, IPyCodeCompletion.PROPOSAL_COMPARATOR);
        }
        results.addAll(results2);
        results.addAll(results3);
        return results.toArray(new ICompletionProposal[results.size()]);
    }

    public String getDescription(IDocument doc, int position) throws Exception {
        PySelection.ActivationTokenAndQual tokenAndQual = PySelection.getActivationTokenAndQual((IDocument)doc, (int)position, (boolean)true, (boolean)false);
        String actTok = tokenAndQual.activationToken;
        if (tokenAndQual.qualifier != null && tokenAndQual.qualifier.length() > 0) {
            if (actTok.length() > 0 && actTok.charAt(actTok.length() - 1) != '.') {
                actTok = String.valueOf(actTok) + '.';
            }
            actTok = String.valueOf(actTok) + tokenAndQual.qualifier;
        }
        return this.consoleCommunication.getDescription(actTok);
    }

    public void close() {
        if (this.consoleCommunication != null) {
            try {
                this.consoleCommunication.close();
            }
            catch (Exception exception) {}
            this.consoleCommunication = null;
        }
        for (Runnable r : this.closeRunnables) {
            r.run();
        }
        this.closeRunnables = null;
    }

    public void setConsoleCommunication(IScriptConsoleCommunication protocol) {
        this.consoleCommunication = protocol;
    }

    public IScriptConsoleCommunication getConsoleCommunication() {
        return this.consoleCommunication;
    }

    public void addCloseOperation(Runnable runnable) {
        this.closeRunnables.add(runnable);
    }

    public void setNaturesUsed(List<IPythonNature> naturesUsed) {
        if (naturesUsed == null) {
            naturesUsed = new ArrayList<IPythonNature>();
        }
        this.naturesUsed = naturesUsed;
    }

    public void setInterpreterInfo(IInterpreterInfo interpreterInfo) {
        this.interpreterInfo = interpreterInfo;
    }

    public IInterpreterInfo getInterpreterInfo() {
        return this.interpreterInfo;
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public PyStackFrame getFrame() {
        return this.frame;
    }

    public void linkWithDebugSelection(boolean isLinkedWithDebug) {
        this.consoleCommunication.linkWithDebugSelection(isLinkedWithDebug);
    }
}

