/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.env;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.python.pydev.core.log.Log;
import org.python.pydev.jython.IPythonInterpreter;
import org.python.pydev.jython.JythonPlugin;
import org.python.pydev.shared_core.io.PipedInputStream;

public class JythonEclipseProcess
extends Process {
    private PipedInputStream outputStream;
    private PipedInputStream errorStream;
    private Object lock;
    private IPythonInterpreter interpreter;
    private Thread thread;

    public JythonEclipseProcess(final String script, final int port, final int clientPort) {
        try {
            this.outputStream = new PipedInputStream();
            this.errorStream = new PipedInputStream();
            this.lock = new Object();
            this.thread = new Thread(){

                @Override
                public void run() {
                    File fileToExec = new File(script);
                    HashMap<String, String> locals = new HashMap<String, String>();
                    locals.put("__name__", "__main__");
                    JythonEclipseProcess.this.interpreter = JythonPlugin.newPythonInterpreter((boolean)false, (boolean)false);
                    JythonEclipseProcess.this.interpreter.setErr(((JythonEclipseProcess)JythonEclipseProcess.this).errorStream.internalOutputStream);
                    JythonEclipseProcess.this.interpreter.setOut(((JythonEclipseProcess)JythonEclipseProcess.this).outputStream.internalOutputStream);
                    Throwable e = JythonPlugin.exec(locals, (IPythonInterpreter)JythonEclipseProcess.this.interpreter, (File)fileToExec, (File[])new File[]{fileToExec.getParentFile()}, (String[])new String[]{"''", "'" + port + "'", "'" + clientPort + "'"});
                    if (e != null) {
                        Log.log((Throwable)e);
                    }
                }
            };
            this.thread.start();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream.internalOutputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.outputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitFor() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
        return 0;
    }

    @Override
    public int exitValue() {
        throw new IllegalThreadStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.errorStream != null) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

