/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.prefs;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;

public class InteractiveConsoleUMDPrefs
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFERENCES_ID = "org.python.pydev.debug.newconsole.prefs.InteractiveConsoleUMDPrefs";

    public InteractiveConsoleUMDPrefs() {
        super(0);
    }

    public void init(IWorkbench workbench) {
        this.setDescription("PyDev User Module Deleter (UMD) preferences.\n\nUMD forces Python to reload modules which were imported when executing a script in the external console with the 'runfile' function.");
        this.setPreferenceStore(PydevDebugPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor("INTERACTIVE_CONSOLE_UMD_ENABLED", "Enable UMD", p));
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor", "", p));
        this.addField((FieldEditor)new BooleanFieldEditor("INTERACTIVE_CONSOLE_UMD_VERBOSE", "Show reloaded modules list", p));
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor", "", p));
        this.addField((FieldEditor)new ListEditor("INTERACTIVE_CONSOLE_UMD_EXCLUDE_MODULE_LIST", "UMD Excluded Modules:", p){

            protected String createList(String[] items) {
                return StringUtils.join((String)",", (String[])items);
            }

            protected String[] parseString(String stringList) {
                return stringList.split(",");
            }

            protected String getNewInputObject() {
                InputDialog d = new InputDialog(this.getShell(), "New Excluded Module", "Add the module you want to exclude.", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.indexOf(44) != -1) {
                            return "The input cannot have a comma";
                        }
                        return null;
                    }
                });
                if (d.open() == 0) {
                    return d.getValue();
                }
                return null;
            }

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns);
                List listControl = this.getListControl(parent);
                GridData layoutData = (GridData)listControl.getLayoutData();
                layoutData.heightHint = 300;
            }
        });
    }

    public static boolean isUMDEnabled() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("INTERACTIVE_CONSOLE_UMD_ENABLED");
        }
        return true;
    }

    public static boolean isUMDVerbose() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("INTERACTIVE_CONSOLE_UMD_VERBOSE");
        }
        return true;
    }

    public static String getUMDExcludeModules() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin != null) {
            return plugin.getPreferenceStore().getString("INTERACTIVE_CONSOLE_UMD_EXCLUDE_MODULE_LIST");
        }
        return "guidata,guiqwt";
    }
}

