/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.pyunit.IPyUnitLaunch;
import org.python.pydev.debug.pyunit.PyUnitTestResult;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.debug.RestartLaunchAction;

public class PyUnitLaunch
implements IPyUnitLaunch {
    private ILaunchConfiguration configuration;
    private ILaunch launch;

    public PyUnitLaunch(ILaunch launch, ILaunchConfiguration configuration) {
        this.launch = launch;
        this.configuration = configuration;
    }

    @Override
    public void stop() {
        try {
            this.launch.terminate();
        }
        catch (DebugException e) {
            Log.log((Throwable)e);
        }
    }

    @Override
    public void relaunch() {
        RestartLaunchAction.relaunch((ILaunch)this.launch, (ILaunchConfiguration)this.configuration);
    }

    @Override
    public void relaunchTestResults(List<PyUnitTestResult> runsToRelaunch) {
        this.relaunchTestResults(runsToRelaunch, null);
    }

    @Override
    public void relaunchTestResults(List<PyUnitTestResult> runsToRelaunch, String mode) {
        FastStringBuffer buf = new FastStringBuffer(100 * runsToRelaunch.size());
        for (PyUnitTestResult pyUnitTestResult : runsToRelaunch) {
            buf.append(pyUnitTestResult.location).append("|").append(pyUnitTestResult.test).append('\n');
        }
        try {
            String launchMode;
            String name = this.configuration.getName();
            ILaunchConfigurationWorkingCopy workingCopy = name.indexOf("[pyunit run]") != -1 ? this.configuration.getWorkingCopy() : this.configuration.copy(String.valueOf(name) + " [pyunit run]");
            workingCopy.setAttribute("org.python.pydev.debug.ATTR_UNITTEST_CONFIGURATION_FILE", buf.toString());
            ILaunchConfiguration newConf = workingCopy.doSave();
            ILaunch l = this.launch;
            if (mode != null && !mode.equals(launchMode = this.launch.getLaunchMode())) {
                l = new Launch(newConf, mode, this.launch.getSourceLocator());
            }
            RestartLaunchAction.relaunch((ILaunch)l, (ILaunchConfiguration)newConf);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

