/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.debug.ui.IDebugPreferencesPageParticipant;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

public class DebugPrefsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public DebugPrefsPage() {
        super("Debug", 1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new IntegerFieldEditor("CONNECT_TIMEOUT", "Connect timeout for debugger (ms)", p, 10));
        BooleanFieldEditor editor = new BooleanFieldEditor("RELOAD_MODULE_ON_CHANGE", "When file is changed, automatically reload module?", 1, p);
        Control c = editor.getDescriptionControl(p);
        c.setToolTipText("The debugger will automatically reload a module,\nwhen a file is saved if this setting is on.\n\nSee pydevd_reload.py for details, limitations and which hooks\nare provided so that your own classes act upon this change.");
        this.addField((FieldEditor)editor);
        editor = new BooleanFieldEditor("DONT_TRACE_ENABLED", "On a step in, skip over methods which have a @DontTrace comment?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("When a comment: # @DontTrace is found after a method, it's skipped by the debugger if this setting is on.\n\nUse Ctrl+1 in a method line to add such a comment.");
        this.addField((FieldEditor)editor);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_debug_preferences_page");
        for (IDebugPreferencesPageParticipant participant : participants) {
            participant.createFieldEditors(this, p);
        }
        editor = new BooleanFieldEditor("DEBUG_MULTIPROCESSING_ENABLED", "Attach to subprocess automatically while debugging?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("Enabling this option will patch the functions related to launching a new process\nand will attempt to automatically connect new launched processes to the debugger.");
        this.addField((FieldEditor)editor);
        editor = new BooleanFieldEditor("KILL_SUBPROCESSES_WHEN_TERMINATING_PROCESS", "When terminating process, kill subprocesses too?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("When this option is turned on, terminating a launch will also terminate subprocesses.");
        this.addField((FieldEditor)editor);
        editor = new BooleanFieldEditor("GEVENT_DEBUGGING", "Gevent compatible debugging?", 1, p);
        c = editor.getDescriptionControl(p);
        c.setToolTipText("When this option is turned on, the debugger will be able to debug GEvent programs.");
        this.addField((FieldEditor)editor);
    }

    public static boolean getReloadModuleOnChange() {
        return PydevPrefs.getPreferences().getBoolean("RELOAD_MODULE_ON_CHANGE");
    }

    public static boolean getDontTraceEnabled() {
        return PydevPrefs.getPreferences().getBoolean("DONT_TRACE_ENABLED");
    }

    public static boolean getDebugMultiprocessingEnabled() {
        return PydevPrefs.getPreferences().getBoolean("DEBUG_MULTIPROCESSING_ENABLED");
    }

    public static boolean getKillSubprocessesWhenTerminatingProcess() {
        return PydevPrefs.getPreferences().getBoolean("KILL_SUBPROCESSES_WHEN_TERMINATING_PROCESS");
    }

    public static boolean getGeventDebugging() {
        return PydevPrefs.getPreferences().getBoolean("GEVENT_DEBUGGING");
    }

    public void addField(FieldEditor editor) {
        super.addField(editor);
    }
}

