/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.utils.PyMarkerUtils;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    protected IVerticalRulerInfo fInfo;
    protected ITextEditor fTextEditor;
    private IBreakpoint fBreakpoint;

    protected IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo info) {
        this.fInfo = info;
    }

    protected IBreakpoint getBreakpointFromLastLineOfActivityInCurrentEditor() {
        List<IBreakpoint> breakpoints = this.getBreakpointsFromCurrentFile(true);
        int size = breakpoints.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return breakpoints.get(0);
        }
        if (size > 1) {
            Log.log((String)"Did not expect more than one breakpoint in the current line. Returning first.");
            return breakpoints.get(0);
        }
        Log.log((String)"Unexpected condition!");
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected IResource getResourceForDebugMarkers() {
        return PyMarkerUtils.getResourceForTextEditor((ITextEditor)this.fTextEditor);
    }

    public boolean isExternalFileEditor() {
        return AbstractBreakpointRulerAction.isExternalFileEditor(this.fTextEditor);
    }

    public IEditorInput getExternalFileEditorInput() {
        return AbstractBreakpointRulerAction.getExternalFileEditorInput(this.fTextEditor);
    }

    public static boolean isExternalFileEditor(ITextEditor editor) {
        IEditorInput externalFileEditorInput = AbstractBreakpointRulerAction.getExternalFileEditorInput(editor);
        return externalFileEditorInput != null;
    }

    public static IEditorInput getExternalFileEditorInput(ITextEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return null;
        }
        if (input instanceof IPathEditorInput) {
            return input;
        }
        try {
            if (input instanceof IURIEditorInput) {
                return input;
            }
        }
        catch (Throwable throwable) {}
        return input;
    }

    protected static boolean isInSameExternalEditor(IMarker marker, IEditorInput externalFileEditorInput) throws CoreException {
        if (marker == null || externalFileEditorInput == null) {
            return false;
        }
        String attribute = (String)marker.getAttribute("org.python.pydev.debug.PYDEV_EXTERNAL_PATH_ID");
        if (attribute != null) {
            File file = PydevFileEditorInput.getFile((IEditorInput)externalFileEditorInput);
            if (file == null) {
                return false;
            }
            if (attribute.equals(FileUtils.getFileAbsolutePath((File)file))) {
                return true;
            }
        }
        return false;
    }

    public static List<IMarker> getMarkersFromCurrentFile(BaseEditor edit, int line) {
        return AbstractBreakpointRulerAction.getMarkersFromEditorResource(PyMarkerUtils.getResourceForTextEditor((ITextEditor)edit), edit.getDocument(), AbstractBreakpointRulerAction.getExternalFileEditorInput((ITextEditor)edit), line, true, edit.getAnnotationModel());
    }

    protected List<IBreakpoint> getBreakpointsFromCurrentFile(boolean onlyIncludeLastLineActivity) {
        List<Tuple<IMarker, IBreakpoint>> markersAndBreakpointsFromEditorResource = AbstractBreakpointRulerAction.getMarkersAndBreakpointsFromEditorResource(this.getResourceForDebugMarkers(), this.getDocument(), this.getExternalFileEditorInput(), this.getInfo().getLineOfLastMouseButtonActivity(), onlyIncludeLastLineActivity, this.getAnnotationModel());
        int size = markersAndBreakpointsFromEditorResource.size();
        ArrayList<IBreakpoint> r = new ArrayList<IBreakpoint>(size);
        int i = 0;
        while (i < size) {
            r.add((IBreakpoint)markersAndBreakpointsFromEditorResource.get((int)i).o2);
            ++i;
        }
        return r;
    }

    private IAnnotationModel getAnnotationModel() {
        if (this.fTextEditor == null) {
            return null;
        }
        IDocumentProvider documentProvider = this.fTextEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
    }

    protected List<IMarker> getMarkersFromCurrentFile(boolean onlyIncludeLastLineActivity) {
        return AbstractBreakpointRulerAction.getMarkersFromEditorResource(this.getResourceForDebugMarkers(), this.getDocument(), this.getExternalFileEditorInput(), this.getInfo().getLineOfLastMouseButtonActivity(), onlyIncludeLastLineActivity, this.getAnnotationModel());
    }

    public static List<IMarker> getMarkersFromEditorResource(IResource resource, IDocument document, IEditorInput externalFileEditorInput, int lastLineActivity, boolean onlyIncludeLastLineActivity, IAnnotationModel annotationModel) {
        List<Tuple<IMarker, IBreakpoint>> markersAndBreakpointsFromEditorResource = AbstractBreakpointRulerAction.getMarkersAndBreakpointsFromEditorResource(resource, document, externalFileEditorInput, lastLineActivity, onlyIncludeLastLineActivity, annotationModel);
        int size = markersAndBreakpointsFromEditorResource.size();
        ArrayList<IMarker> r = new ArrayList<IMarker>(size);
        int i = 0;
        while (i < size) {
            r.add((IMarker)markersAndBreakpointsFromEditorResource.get((int)i).o1);
            ++i;
        }
        return r;
    }

    protected static boolean includesRulerLine(Position position, IDocument document, int line) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    public static List<Tuple<IMarker, IBreakpoint>> getMarkersAndBreakpointsFromEditorResource(IResource resource, IDocument document, IEditorInput externalFileEditorInput, int lastLineActivity, boolean onlyIncludeLastLineActivity, IAnnotationModel annotationModel) {
        ArrayList<Tuple<IMarker, IBreakpoint>> breakpoints = new ArrayList<Tuple<IMarker, IBreakpoint>>();
        try {
            ArrayList<IMarker> markers = new ArrayList<IMarker>();
            boolean isExternalFile = false;
            markers.addAll(Arrays.asList(resource.findMarkers("org.python.pydev.debug.pyStopBreakpointMarker", true, 2)));
            markers.addAll(Arrays.asList(resource.findMarkers("org.python.pydev.debug.pyConditionalStopBreakpointMarker", true, 2)));
            markers.addAll(Arrays.asList(resource.findMarkers("org.python.pydev.debug.djangoStopBreakpointMarker", true, 2)));
            if (!(resource instanceof IFile)) {
                isExternalFile = true;
            }
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            for (IMarker marker : markers) {
                IBreakpoint breakpoint;
                if (marker == null || (breakpoint = breakpointManager.getBreakpoint(marker)) == null || !breakpointManager.isRegistered(breakpoint)) continue;
                Position pos = PyMarkerUtils.getMarkerPosition((IDocument)document, (IMarker)marker, (IAnnotationModel)annotationModel);
                if (!isExternalFile) {
                    if (!onlyIncludeLastLineActivity) {
                        breakpoints.add((Tuple<IMarker, IBreakpoint>)new Tuple((Object)marker, (Object)breakpoint));
                        continue;
                    }
                    if (!AbstractBreakpointRulerAction.includesRulerLine(pos, document, lastLineActivity)) continue;
                    breakpoints.add((Tuple<IMarker, IBreakpoint>)new Tuple((Object)marker, (Object)breakpoint));
                    continue;
                }
                if (!AbstractBreakpointRulerAction.isInSameExternalEditor(marker, externalFileEditorInput)) continue;
                if (!onlyIncludeLastLineActivity) {
                    breakpoints.add((Tuple<IMarker, IBreakpoint>)new Tuple((Object)marker, (Object)breakpoint));
                    continue;
                }
                if (!AbstractBreakpointRulerAction.includesRulerLine(pos, document, lastLineActivity)) continue;
                breakpoints.add((Tuple<IMarker, IBreakpoint>)new Tuple((Object)marker, (Object)breakpoint));
            }
        }
        catch (CoreException x) {
            PydevDebugPlugin.log(4, "Unexpected getMarkers error (recovered properly)", x);
        }
        return breakpoints;
    }
}

