/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.python.pydev.debug.model.PyExceptionBreakPointManager;
import org.python.pydev.debug.ui.PyConfigureExceptionDialog;
import org.python.pydev.debug.ui.actions.PyExceptionListProvider;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.shared_ui.EditorUtils;

public class PyConfigureExceptionAction
extends PyAction
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        PyConfigureExceptionDialog dialog = new PyConfigureExceptionDialog(EditorUtils.getShell(), "", new PyExceptionListProvider(), (ILabelProvider)new LabelProvider(), "");
        PyExceptionBreakPointManager instance = PyExceptionBreakPointManager.getInstance();
        dialog.setInitialElementSelections(instance.getExceptionsList());
        dialog.setTitle("Add Python Exception Breakpoint");
        if (dialog.open() == 0) {
            String[] exceptionArray;
            Object[] selectedItems = dialog.getResult();
            if (selectedItems != null) {
                exceptionArray = new String[selectedItems.length];
                System.arraycopy(selectedItems, 0, exceptionArray, 0, selectedItems.length);
            } else {
                exceptionArray = new String[]{};
            }
            instance.setSkipCaughtExceptionsInSameFunction(dialog.getResultStopOnExceptionsHandledInSameContext());
            instance.setIgnoreExceptionsThrownInLinesWithIgnoreException(dialog.getResultIgnoreExceptionsThrownInLinesWithIgnoreException());
            instance.setBreakOn(dialog.getResultHandleCaughtExceptions(), dialog.getResultHandleUncaughtExceptions(), exceptionArray);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

