/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.debug.ui.actions.AbstractRunEditorAction;
import org.python.pydev.debug.ui.actions.SelectTestLabelProvider;
import org.python.pydev.debug.ui.actions.SelectTestTreeContentProvider;
import org.python.pydev.debug.ui.actions.ShiftListener;
import org.python.pydev.debug.ui.launching.AbstractLaunchShortcut;
import org.python.pydev.debug.ui.launching.FileOrResource;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.pyunit.preferences.PyUnitPrefsPage2;
import org.python.pydev.shared_core.callbacks.ICallbackListener;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.dialogs.DialogMemento;
import org.python.pydev.ui.dialogs.TreeSelectionDialog;

public class RunEditorAsCustomUnitTestAction
extends AbstractRunEditorAction {
    public void run(IAction action) {
        PyEdit pyEdit = this.getPyEdit();
        final Tuple<String, IInterpreterManager> launchConfigurationTypeAndInterpreterManager = this.getLaunchConfigurationTypeAndInterpreterManager(pyEdit, true);
        Shell shell = EditorUtils.getShell();
        final DialogMemento memento = new DialogMemento(shell, "org.python.pydev.debug.ui.actions.RunEditorAsCustomUnitTestAction");
        SimpleNode ast = pyEdit.getAST();
        final ShiftListener shiftListener = new ShiftListener();
        Display d = shell.getDisplay();
        d.addFilter(1, (Listener)shiftListener);
        d.addFilter(2, (Listener)shiftListener);
        try {
            TreeSelectionDialog dialog = new TreeSelectionDialog(shell, (ILabelProvider)new SelectTestLabelProvider(), new SelectTestTreeContentProvider()){
                private Label labelShiftToDebug;

                public boolean close() {
                    memento.writeSettings(this.getShell());
                    return super.close();
                }

                public Control createDialogArea(Composite parent) {
                    memento.readSettings();
                    Control ret = super.createDialogArea(parent);
                    ret.addTraverseListener(new TraverseListener(){

                        public void keyTraversed(TraverseEvent e) {
                            if (e.detail == 4) {
                                this.okPressed();
                            }
                        }
                    });
                    return ret;
                }

                protected Control createButtonBar(Composite parent) {
                    Composite buttonBar = new Composite(parent, 0);
                    GridLayout layout = new GridLayout();
                    layout.numColumns = 2;
                    buttonBar.setLayout((Layout)layout);
                    GridData data = new GridData();
                    data.horizontalAlignment = 4;
                    data.grabExcessHorizontalSpace = true;
                    buttonBar.setLayoutData((Object)data);
                    Link configTestRunner = new Link(buttonBar, 8);
                    configTestRunner.setText(" <a>Configure test runner</a>");
                    configTestRunner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PyUnitPrefsPage2.showPage();
                        }
                    });
                    data = new GridData();
                    data.horizontalAlignment = 1;
                    data.grabExcessHorizontalSpace = true;
                    configTestRunner.setLayoutData((Object)data);
                    this.labelShiftToDebug = new Label(buttonBar, 0);
                    this.labelShiftToDebug.setText("Run: Normal   (Press Shift to Debug)");
                    data = new GridData();
                    data.horizontalAlignment = 3;
                    data.grabExcessHorizontalSpace = true;
                    this.labelShiftToDebug.setLayoutData((Object)data);
                    shiftListener.onChanged.registerListener((ICallbackListener)new ICallbackListener<Boolean>(){

                        public Object call(Boolean shiftPressed) {
                            if (shiftPressed.booleanValue()) {
                                labelShiftToDebug.setText("Run: Debug   (Release Shift for Normal)");
                            } else {
                                labelShiftToDebug.setText("Run: Normal   (Press Shift to Debug)");
                            }
                            labelShiftToDebug.getParent().layout(true);
                            return null;
                        }
                    });
                    return buttonBar;
                }

                protected Point getInitialSize() {
                    return memento.getInitialSize(super.getInitialSize(), this.getShell());
                }

                protected Point getInitialLocation(Point initialSize) {
                    return memento.getInitialLocation(initialSize, super.getInitialLocation(initialSize), this.getShell());
                }

                protected void computeResult() {
                    this.doFinalUpdateBeforeComputeResult();
                    IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
                    ArrayList<Object> list = selection.toList();
                    if (list.size() > 0) {
                        this.setResult(list);
                    } else {
                        Tree tree = this.getTreeViewer().getTree();
                        TreeItem[] items = tree.getItems();
                        list = new ArrayList<Object>();
                        this.createListWithLeafs(items, list);
                        this.setResult(list);
                    }
                }

                private void createListWithLeafs(TreeItem[] items, List<Object> leafObjectsList) {
                    TreeItem[] treeItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        TreeItem[] children = item.getItems();
                        if (children.length == 0) {
                            leafObjectsList.add(item.getData());
                        } else {
                            this.createListWithLeafs(children, leafObjectsList);
                        }
                        ++n2;
                    }
                }
            };
            dialog.setTitle("PyDev: Select tests to run");
            dialog.setMessage("Select the tests to run (press enter to run tests shown/selected)");
            PySelection ps = pyEdit.createPySelection();
            String selectedText = ps.getSelectedText();
            if (selectedText.length() > 0 && PyStringUtils.isValidIdentifier((String)selectedText, (boolean)false)) {
                dialog.setInitialFilter(String.valueOf(selectedText) + " ");
            } else {
                dialog.setInitialFilter("test");
            }
            dialog.setAllowMultiple(true);
            dialog.setInput((Object)ast);
            int open = dialog.open();
            if (open != 0) {
                return;
            }
            Object[] result = dialog.getResult();
            FastStringBuffer buf = new FastStringBuffer();
            if (result != null && result.length > 0) {
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ASTEntry entry = (ASTEntry)o;
                    if (entry.node instanceof ClassDef) {
                        if (buf.length() > 0) {
                            buf.append(',');
                        }
                        buf.append(NodeUtils.getFullRepresentationString((SimpleNode)entry.node));
                    } else if (entry.node instanceof FunctionDef && entry.parent == null) {
                        if (buf.length() > 0) {
                            buf.append(',');
                        }
                        buf.append(NodeUtils.getFullRepresentationString((SimpleNode)entry.node));
                    } else if (entry.node instanceof FunctionDef && entry.parent != null && entry.parent.node instanceof ClassDef) {
                        if (buf.length() > 0) {
                            buf.append(',');
                        }
                        buf.append(NodeUtils.getFullRepresentationString((SimpleNode)entry.parent.node));
                        buf.append('.');
                        buf.append(NodeUtils.getFullRepresentationString((SimpleNode)entry.node));
                    }
                    ++n2;
                }
            }
            final String arguments = buf.length() > 0 ? buf.toString() : "";
            AbstractLaunchShortcut shortcut = new AbstractLaunchShortcut(){

                @Override
                protected String getLaunchConfigurationType() {
                    return (String)launchConfigurationTypeAndInterpreterManager.o1;
                }

                @Override
                protected IInterpreterManager getInterpreterManager(IProject project) {
                    return (IInterpreterManager)launchConfigurationTypeAndInterpreterManager.o2;
                }

                @Override
                public ILaunchConfigurationWorkingCopy createDefaultLaunchConfigurationWithoutSaving(FileOrResource[] resource) throws CoreException {
                    ILaunchConfigurationWorkingCopy workingCopy = super.createDefaultLaunchConfigurationWithoutSaving(resource);
                    if (arguments.length() > 0) {
                        workingCopy.setAttribute("org.python.pydev.debug.ATTR_UNITTEST_TESTS", arguments);
                    }
                    return workingCopy;
                }

                @Override
                protected List<ILaunchConfiguration> findExistingLaunchConfigurations(FileOrResource[] file) {
                    ArrayList<ILaunchConfiguration> ret = new ArrayList<ILaunchConfiguration>();
                    List<ILaunchConfiguration> existing = super.findExistingLaunchConfigurations(file);
                    for (ILaunchConfiguration launch : existing) {
                        boolean matches = false;
                        try {
                            matches = launch.getAttribute("org.python.pydev.debug.ATTR_UNITTEST_TESTS", "").equals(arguments);
                        }
                        catch (CoreException coreException) {}
                        if (!matches) continue;
                        ret.add(launch);
                    }
                    return ret;
                }
            };
            if (shiftListener.shiftPressed) {
                shortcut.launch((IEditorPart)pyEdit, "debug");
            } else {
                shortcut.launch((IEditorPart)pyEdit, "run");
            }
        }
        finally {
            d.removeFilter(1, (Listener)shiftListener);
            d.removeFilter(2, (Listener)shiftListener);
        }
    }
}

