/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug;

import com.python.pydev.debug.remote.IRemoteDebuggerListener;
import com.python.pydev.debug.remote.RemoteDebuggerServer;
import com.python.pydev.debug.remote.client_api.PydevRemoteDebuggerServer;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.ui.IStartup;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.utils.PlatformUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.shared_ui.utils.UIUtils;

public class DebugEarlyStartup
implements IStartup {
    private final Job checkAlwaysOnJob = new Job("Check debug server always on"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                DebugEarlyStartup.this.checkAlwaysOn(PydevPlugin.getDefault().getPreferenceStore());
            }
            catch (NullPointerException nullPointerException) {}
            return Status.OK_STATUS;
        }
    };
    private static volatile boolean checkedOnOnce = false;

    public void earlyStartup() {
        IPreferenceStore preferenceStore = PydevPlugin.getDefault().getPreferenceStore();
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("DEBUG_SERVER_STARTUP".equals(event.getProperty())) {
                    DebugEarlyStartup.this.checkAlwaysOnJob.schedule(200L);
                }
            }
        });
        RemoteDebuggerServer.getInstance().addListener(new IRemoteDebuggerListener(){

            @Override
            public void stopped(RemoteDebuggerServer remoteDebuggerServer) {
                DebugEarlyStartup.this.checkAlwaysOnJob.schedule(200L);
            }
        });
        this.checkAlwaysOnJob.schedule(500L);
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPreferenceStore preferenceStore2;
                        int forceOption;
                        DebugEvent debugEvent = debugEventArray[n2];
                        if (debugEvent.getKind() == 2 && debugEvent.getDetail() == 16 && debugEvent.getSource() instanceof PyThread && (forceOption = (preferenceStore2 = PydevPlugin.getDefault().getPreferenceStore()).getInt("FORCE_SHOW_SHELL_ON_BREAKPOINT2")) != 0) {
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    Shell activeShell = UIUtils.getActiveShell();
                                    if (activeShell != null) {
                                        DebugEarlyStartup.this.forceActive(activeShell, forceOption);
                                    }
                                }
                            };
                            boolean runNowIfInUiThread = true;
                            RunInUiThread.async((Runnable)r, (boolean)runNowIfInUiThread);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public void forceActive(Shell shell, int forceOption) {
        TaskBar taskBar;
        shell.setMinimized(false);
        if (forceOption == 1 && PlatformUtils.isWindowsPlatform()) {
            try {
                Class<?> OSClass = Class.forName("org.eclipse.swt.internal.win32.OS");
                Method hFromMethod = OSClass.getMethod("GetForegroundWindow", new Class[0]);
                Method SetForegroundWindowMethod = OSClass.getMethod("SetForegroundWindow", Integer.TYPE);
                Method GetWindowThreadProcessIdMethod = OSClass.getMethod("GetWindowThreadProcessId", Integer.TYPE, int[].class);
                int hFrom = (Integer)hFromMethod.invoke(OSClass, new Object[0]);
                long asLong = shell.handle;
                int shellHandle = (int)asLong;
                if (hFrom <= 0) {
                    SetForegroundWindowMethod.invoke(OSClass, shellHandle);
                    return;
                }
                if (shellHandle == hFrom) {
                    return;
                }
                int pid = (Integer)GetWindowThreadProcessIdMethod.invoke(OSClass, hFrom, null);
                int _threadid = (Integer)GetWindowThreadProcessIdMethod.invoke(OSClass, shellHandle, null);
                if (_threadid == pid) {
                    SetForegroundWindowMethod.invoke(OSClass, shellHandle);
                    return;
                }
                if (pid > 0) {
                    Method AttachThreadInputMethod = OSClass.getMethod("AttachThreadInput", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    if (!((Boolean)AttachThreadInputMethod.invoke(OSClass, _threadid, pid, true)).booleanValue()) {
                        return;
                    }
                    SetForegroundWindowMethod.invoke(OSClass, shellHandle);
                    AttachThreadInputMethod.invoke(OSClass, _threadid, pid, false);
                }
                String[] stringArray = new String[]{"BringWindowToTop", "UpdateWindow", "SetActiveWindow"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    Method method = OSClass.getMethod(s, Integer.TYPE);
                    method.invoke(OSClass, shellHandle);
                    ++n2;
                }
                return;
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
                shell.forceActive();
                shell.setActive();
            }
        }
        if (forceOption == 2 && (taskBar = shell.getDisplay().getSystemTaskBar()) != null) {
            TaskItem item = taskBar.getItem(shell);
            if (item == null) {
                item = taskBar.getItem(null);
            }
            RunInUiThread.async((Runnable)new ShowIndeterminateProgressRunnable(shell, item, System.currentTimeMillis() + 5000L));
        }
    }

    public void checkAlwaysOn(final IPreferenceStore preferenceStore) {
        int debugServerStartup = preferenceStore.getInt("DEBUG_SERVER_STARTUP");
        if (debugServerStartup != 0) {
            boolean runNowIfInUiThread = true;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    int debugServerStartup = preferenceStore.getInt("DEBUG_SERVER_STARTUP");
                    if (debugServerStartup == 2 && !PydevRemoteDebuggerServer.isRunning()) {
                        PydevRemoteDebuggerServer.startServer();
                    } else if (debugServerStartup == 1 && !checkedOnOnce && !PydevRemoteDebuggerServer.isRunning()) {
                        PydevRemoteDebuggerServer.startServer();
                    }
                    checkedOnOnce = true;
                }
            };
            RunInUiThread.async((Runnable)r, (boolean)runNowIfInUiThread);
        }
    }

    private static class ShowIndeterminateProgressRunnable
    implements Runnable {
        private long blinkUntil;
        private TaskItem item;

        public ShowIndeterminateProgressRunnable(Shell shell, TaskItem item, long blinkUntil) {
            this.blinkUntil = blinkUntil;
            this.item = item;
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() < this.blinkUntil) {
                this.item.setProgressState(2);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            try {
                                this.wait(300L);
                            }
                            catch (InterruptedException e) {
                                Log.log((Throwable)e);
                            }
                        }
                        RunInUiThread.async((Runnable)ShowIndeterminateProgressRunnable.this);
                    }
                }.start();
            } else {
                this.item.setProgressState(-1);
            }
        }
    }
}

