/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.shared_core.io.ThreadStreamReader;

public class ShowProcessOutputDialog
extends Dialog {
    private static final int NUMBER_OF_COLUMNS = 2;
    protected Text output;
    private ThreadStreamReader err;
    private ThreadStreamReader std;
    private volatile boolean disposed = false;

    public ShowProcessOutputDialog(Shell parentShell, final Process process) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.std = new ThreadStreamReader(process.getInputStream());
        this.err = new ThreadStreamReader(process.getErrorStream());
        this.std.start();
        this.err.start();
        parentShell.getDisplay().timerExec(250, new Runnable(){

            @Override
            public void run() {
                if (ShowProcessOutputDialog.this.disposed) {
                    ShowProcessOutputDialog.this.std.stopGettingOutput();
                    ShowProcessOutputDialog.this.err.stopGettingOutput();
                    return;
                }
                try {
                    int exitValue = process.exitValue();
                    String stdout = ShowProcessOutputDialog.this.std.getAndClearContents();
                    String stderr = ShowProcessOutputDialog.this.err.getAndClearContents();
                    ShowProcessOutputDialog.this.output.append(stdout);
                    ShowProcessOutputDialog.this.output.append(stderr);
                    ShowProcessOutputDialog.this.output.append("Process finished with exitValue: " + exitValue);
                }
                catch (Exception exception) {
                    String stdout = ShowProcessOutputDialog.this.std.getAndClearContents();
                    String stderr = ShowProcessOutputDialog.this.err.getAndClearContents();
                    ShowProcessOutputDialog.this.output.append(stdout);
                    ShowProcessOutputDialog.this.output.append(stderr);
                    Display.getCurrent().timerExec(250, (Runnable)this);
                }
            }
        });
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Process output");
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(top, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.output = new Text(composite, 2634);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.output.setLayoutData((Object)gridData);
        return top;
    }

    protected void constrainShellSize() {
        Shell shell = this.getShell();
        shell.setSize(640, 480);
        Rectangle shellBounds = this.getParentShell().getBounds();
        shell.setLocation(shellBounds.x + (shellBounds.width - 640) / 2, shellBounds.y + (shellBounds.height - 480) / 2);
        super.constrainShellSize();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Close", true);
    }

    public int open() {
        try {
            int n = super.open();
            return n;
        }
        finally {
            this.disposed = true;
            this.std.stopGettingOutput();
            this.err.stopGettingOutput();
        }
    }
}

