/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.model;

import com.python.pydev.debug.model.ProcessServer;
import com.python.pydev.debug.model.XMLMessage;
import com.python.pydev.debug.remote.RemoteDebuggerServer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.IExceptionsBreakpointListener;
import org.python.pydev.debug.model.IPropertyTraceListener;
import org.python.pydev.debug.model.PyExceptionBreakPointManager;
import org.python.pydev.debug.model.PyPropertyTraceManager;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.shared_core.structure.Tuple;

public class PyDebugTargetServer
extends AbstractDebugTarget {
    private boolean isTerminated;

    public PyDebugTargetServer(ILaunch launch, IPath[] file, RemoteDebuggerServer debugger) {
        this.file = file;
        this.debugger = debugger;
        this.threads = new PyThread[0];
        this.launch = launch;
        if (launch != null) {
            IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                if (target instanceof PyDebugTargetServer && target.isTerminated()) {
                    launch.removeDebugTarget(target);
                }
                ++n2;
            }
            launch.addDebugTarget((IDebugTarget)this);
        }
        debugger.addTarget(this);
        PyExceptionBreakPointManager.getInstance().addListener((IExceptionsBreakpointListener)this);
        PyPropertyTraceManager.getInstance().addListener((IPropertyTraceListener)this);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() {
        this.isTerminated = true;
        super.terminate();
    }

    public void setTerminated() {
        this.isTerminated = true;
    }

    public void launchRemoved(ILaunch launch) {
        if (launch == this.launch) {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            breakpointManager.removeBreakpointListener((IBreakpointListener)this);
            PyExceptionBreakPointManager.getInstance().removeListener((IExceptionsBreakpointListener)this);
            PyPropertyTraceManager.getInstance().removeListener((IPropertyTraceListener)this);
        }
    }

    public void processCommand(String sCmdCode, String sSeqCode, String payload) {
        if (Integer.parseInt(sCmdCode) == 116) {
            ProcessServer serverProcess = this.getDebugger().getServerProcess();
            Tuple<String, Integer> message = XMLMessage.getMessage(payload);
            if ((Integer)message.o2 == 1) {
                serverProcess.writeToStdOut((String)message.o1);
            } else {
                serverProcess.writeToStdErr((String)message.o1);
            }
        } else {
            super.processCommand(sCmdCode, sSeqCode, payload);
        }
    }

    public RemoteDebuggerServer getDebugger() {
        return (RemoteDebuggerServer)super.getDebugger();
    }

    public IProcess getProcess() {
        return this.getDebugger().getIProcess();
    }
}

