/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.actions;

import com.python.pydev.refactoring.RefactoringPlugin;
import com.python.pydev.refactoring.markoccurrences.MarkOccurrencesJob;
import java.lang.ref.WeakReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.EditorUtils;

public class ToggleMarkOccurrences
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextEditor activeEditor = EditorUtils.getActiveEditor();
        if (!(activeEditor instanceof PyEdit)) {
            return null;
        }
        PyEdit editor = (PyEdit)activeEditor;
        try {
            IPreferenceStore store = RefactoringPlugin.getDefault().getPreferenceStore();
            boolean prev = store.getBoolean("USE_MARK_OCCURRENCES");
            store.setValue("USE_MARK_OCCURRENCES", !prev);
            editor.getStatusLineManager().setMessage("Toggled mark occurrences. Currently: " + (prev ? "Off" : "On"));
            MarkOccurrencesJob.scheduleRequest(new WeakReference<PyEdit>(editor), editor.createTextSelectionUtils(), 0);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }
}

