/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class RefactorerFindReferences {
    public static ArrayList<Tuple<List<ModulesKey>, IPythonNature>> FORCED_RETURN;

    public List<Tuple<List<ModulesKey>, IPythonNature>> findPossibleReferences(RefactoringRequest request) {
        String initialName = request.initialName;
        ArrayList<Tuple<List<ModulesKey>, IPythonNature>> ret = request.getPossibleReferences(initialName);
        if (ret != null) {
            return ret;
        }
        if (FORCED_RETURN != null) {
            ret = new ArrayList<Tuple<List<ModulesKey>, IPythonNature>>();
            for (Tuple<List<ModulesKey>, IPythonNature> f : FORCED_RETURN) {
                for (ModulesKey k : (List)f.o1) {
                    String object = FileUtils.getFileContents((File)k.file);
                    if (object.indexOf(request.initialName) == -1) continue;
                    ret.add((Tuple<List<ModulesKey>, IPythonNature>)new Tuple(Arrays.asList(k), (Object)((IPythonNature)f.o2)));
                }
            }
            return ret;
        }
        ret = new ArrayList();
        try {
            try {
                IProject project = request.nature.getProject();
                ArrayList<Tuple> infoAndNature = null;
                if (project == null) {
                    if (request.nature instanceof SystemPythonNature) {
                        SystemPythonNature systemPythonNature = (SystemPythonNature)request.nature;
                        int interpreterType = systemPythonNature.getInterpreterType();
                        List naturesRelatedTo = PythonNature.getPythonNaturesRelatedTo((int)interpreterType);
                        infoAndNature = new ArrayList<Tuple>();
                        for (IPythonNature iPythonNature : naturesRelatedTo) {
                            AbstractAdditionalDependencyInfo o1;
                            if (iPythonNature.getProject() == null || !iPythonNature.getProject().isAccessible() || (o1 = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)iPythonNature)) == null) continue;
                            infoAndNature.add(new Tuple((Object)o1, (Object)iPythonNature));
                        }
                    }
                } else {
                    infoAndNature = AdditionalProjectInterpreterInfo.getAdditionalInfoAndNature((IPythonNature)request.nature, (boolean)false, (boolean)true, (boolean)true);
                }
                if (infoAndNature == null || infoAndNature.size() == 0) {
                    return ret;
                }
                request.getMonitor().beginTask("Find possible references", infoAndNature.size());
                request.getMonitor().setTaskName("Find possible references");
                try {
                    for (Tuple tuple : infoAndNature) {
                        try {
                            request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 1));
                            if (tuple.o1 == null || tuple.o2 == null) continue;
                            List modulesWithToken = ((AbstractAdditionalTokensInfo)tuple.o1).getModulesWithToken(request.nature.getProject(), initialName, request.getMonitor());
                            ret.add((Tuple<List<ModulesKey>, IPythonNature>)new Tuple((Object)modulesWithToken, (Object)((IPythonNature)tuple.o2)));
                        }
                        finally {
                            request.popMonitor().done();
                        }
                    }
                }
                finally {
                    request.getMonitor().done();
                }
            }
            catch (MisconfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        request.setPossibleReferences(initialName, ret);
        return ret;
    }
}

