/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search.copied;

import com.python.pydev.refactoring.refactorer.search.AbstractPythonSearchQuery;
import com.python.pydev.refactoring.refactorer.search.PythonFileSearchResult;
import com.python.pydev.refactoring.refactorer.search.copied.FileSearchPage;
import com.python.pydev.refactoring.refactorer.search.copied.IFileSearchContentProvider;
import com.python.pydev.ui.search.FileMatch;
import com.python.pydev.ui.search.LineElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class FileTreeContentProvider
implements ITreeContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private AbstractTextSearchResult fResult;
    private FileSearchPage fPage;
    private AbstractTreeViewer fTreeViewer;
    private Map<Object, Set> fChildrenMap;

    FileTreeContentProvider(FileSearchPage page, AbstractTreeViewer viewer) {
        this.fPage = page;
        this.fTreeViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = this.getChildren(inputElement);
        int elementLimit = this.getElementLimit();
        if (elementLimit != -1 && elementLimit < children.length) {
            Object[] limitedChildren = new Object[elementLimit];
            System.arraycopy(children, 0, limitedChildren, 0, elementLimit);
            return limitedChildren;
        }
        return children;
    }

    private int getElementLimit() {
        try {
            return this.fPage.getElementLimit();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof PythonFileSearchResult) {
            this.initialize((PythonFileSearchResult)((Object)newInput));
        }
    }

    private synchronized void initialize(AbstractTextSearchResult result) {
        boolean showLineMatches;
        this.fResult = result;
        this.fChildrenMap = new HashMap<Object, Set>();
        boolean bl = showLineMatches = !((AbstractPythonSearchQuery)this.fResult.getQuery()).isFileNameSearch();
        if (result != null) {
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                if (showLineMatches) {
                    Match[] matches = result.getMatches(elements[i]);
                    int j = 0;
                    while (j < matches.length) {
                        this.insert(((FileMatch)matches[j]).getLineElement(), false);
                        ++j;
                    }
                } else {
                    this.insert(elements[i], false);
                }
                ++i;
            }
        }
    }

    private void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.fTreeViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fTreeViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild(this.fResult, child) && refreshViewer) {
            this.fTreeViewer.add((Object)this.fResult, child);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        HashSet<Object> children = this.fChildrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.fChildrenMap.put(parent, children);
        }
        return children.add(child);
    }

    private boolean hasChild(Object parent, Object child) {
        Set children = this.fChildrenMap.get(parent);
        return children != null && children.contains(child);
    }

    private void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.fTreeViewer.refresh(element);
            }
        } else if (!this.hasMatches(element)) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, this.fResult);
                if (refreshViewer) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.fTreeViewer.refresh(element);
        }
    }

    private boolean hasMatches(Object element) {
        if (element instanceof LineElement) {
            LineElement lineElement = (LineElement)element;
            return lineElement.getNumberOfMatches(this.fResult) > 0;
        }
        return this.fResult.getMatchCount(element) > 0;
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set siblings = this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set children = this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public synchronized void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (!(updatedElements[i] instanceof LineElement)) {
                if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                    this.insert(updatedElements[i], true);
                } else {
                    this.remove(updatedElements[i], true);
                }
            } else {
                LineElement lineElement = (LineElement)updatedElements[i];
                int nMatches = lineElement.getNumberOfMatches(this.fResult);
                if (nMatches > 0) {
                    if (this.hasChild(lineElement.getParent(), lineElement)) {
                        this.fTreeViewer.update(new Object[]{lineElement, lineElement.getParent()}, null);
                    } else {
                        this.insert(lineElement, true);
                    }
                } else {
                    this.remove(lineElement, true);
                }
            }
            ++i;
        }
    }

    @Override
    public void clear() {
        this.initialize(this.fResult);
        this.fTreeViewer.refresh();
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            return null;
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getParent();
        }
        if (element instanceof LineElement) {
            return ((LineElement)element).getParent();
        }
        if (element instanceof FileMatch) {
            FileMatch match = (FileMatch)element;
            return match.getLineElement();
        }
        return null;
    }
}

