/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.tdd;

import com.python.pydev.refactoring.tdd.AbstractPyCreateAction;
import com.python.pydev.refactoring.tdd.AbstractTddRefactorCompletion;
import com.python.pydev.refactoring.tdd.TddRefactorCompletion;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public final class TddRefactorCompletionInInexistentModule
extends AbstractTddRefactorCompletion {
    private File module;
    private List<String> parametersAfterCall;
    private AbstractPyCreateAction pyCreateAction;
    private PySelection ps;

    public TddRefactorCompletionInInexistentModule(String replacementString, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, PyEdit edit, File module, List<String> parametersAfterCall, AbstractPyCreateAction pyCreateAction, PySelection ps) {
        super(edit, replacementString, 0, 0, 0, image, displayString, contextInformation, additionalProposalInfo, priority);
        this.module = module;
        this.parametersAfterCall = parametersAfterCall;
        this.pyCreateAction = pyCreateAction;
        this.ps = ps;
    }

    public void apply(IDocument document) {
        Log.log((String)"This apply should not be called as it implements ICompletionProposalExtension2.");
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IContainer container;
        ArrayList<File> parents = new ArrayList<File>();
        File f = this.module.getParentFile();
        while (f != null && !f.exists()) {
            parents.add(f);
            f = f.getParentFile();
        }
        IProject project = null;
        if (this.edit != null) {
            project = this.edit.getProject();
        }
        if ((container = new PySourceLocatorBase().getContainerForLocation(Path.fromOSString((String)f.getAbsolutePath()), project)) == null) {
            return;
        }
        Collections.reverse(parents);
        int size = parents.size();
        int i = 0;
        while (i < size) {
            IFile file;
            File parent = (File)parents.get(i);
            IFolder folder = container.getFolder((IPath)new Path(parent.getName()));
            if (!folder.exists()) {
                try {
                    folder.create(true, true, null);
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            if (!(file = (container = folder).getFile((IPath)new Path("__init__" + FileTypesPreferencesPage.getDefaultDottedPythonExtension()))).exists()) {
                try {
                    file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            ++i;
        }
        IFile file = container.getFile((IPath)new Path(this.module.getName()));
        if (!file.exists()) {
            try {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        PyOpenAction openAction = new PyOpenAction();
        openAction.run(new ItemPointer((Object)file));
        PyEdit pyEdit = (PyEdit)openAction.editor;
        TddRefactorCompletion completion = new TddRefactorCompletion(this.fReplacementString, this.fImage, this.fDisplayString, this.fContextInformation, this.fAdditionalProposalInfo, 0, pyEdit, 1, this.parametersAfterCall, this.pyCreateAction, this.ps);
        completion.apply((ITextViewer)pyEdit.getEditorSourceViewer(), '\n', 0, 0);
        this.forceReparseInBaseEditorAnd(pyEdit);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }
}

