/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.refactoring.wizards.IRefactorRenameProcess;
import com.python.pydev.refactoring.wizards.RefactorProcessFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.core.IModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.structure.Location;
import org.python.pydev.shared_core.structure.Tuple;

public class PyReferenceSearcher {
    private final Map<RefactoringRequest, List<IRefactorRenameProcess>> requestToProcesses = new HashMap<RefactoringRequest, List<IRefactorRenameProcess>>();
    private static final String INVALID_DEFINITION = "The definition found is not valid: ";

    public PyReferenceSearcher(RefactoringRequest ... requests) {
        RefactoringRequest[] refactoringRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringRequest refactoringRequest = refactoringRequestArray[n2];
            this.requestToProcesses.put(refactoringRequest, new ArrayList());
            ++n2;
        }
    }

    public void prepareSearch(RefactoringRequest request) throws SearchException {
        ItemPointer[] pointers;
        List<IRefactorRenameProcess> processes = this.requestToProcesses.get(request);
        processes.clear();
        if (request.isModuleRenameRefactoringRequest()) {
            IModule module = request.getModule();
            pointers = new ItemPointer[]{new ItemPointer((Object)request.file, new Location(0, 0), new Location(0, 0), new Definition(1, 1, "", null, null, module, false), null)};
        } else {
            SimpleNode ast = request.getAST();
            if (ast == null) {
                throw new SearchException("AST not generated (syntax error).");
            }
            IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
            request.communicateWork("Finding definition");
            pointers = pyRefactoring.findDefinition(request);
        }
        if (pointers.length == 0) {
            IRefactorRenameProcess p = RefactorProcessFactory.getRenameAnyProcess();
            processes.add(p);
        } else {
            ItemPointer[] itemPointerArray = pointers;
            int n = pointers.length;
            int n2 = 0;
            while (n2 < n) {
                ItemPointer pointer = itemPointerArray[n2];
                if (pointer.definition == null) {
                    throw new SearchException(INVALID_DEFINITION + pointer);
                }
                IRefactorRenameProcess p = RefactorProcessFactory.getProcess(pointer.definition, request);
                if (p == null) {
                    throw new SearchException(INVALID_DEFINITION + pointer.definition);
                }
                processes.add(p);
                ++n2;
            }
        }
        if (processes.isEmpty()) {
            throw new SearchException("The pre-conditions were not satisfied.");
        }
    }

    public void search(RefactoringRequest request) throws SearchException, OperationCanceledException {
        for (IRefactorRenameProcess p : this.requestToProcesses.get(request)) {
            request.checkCancelled();
            p.clear();
            RefactoringStatus status = new RefactoringStatus();
            request.pushMonitor((IProgressMonitor)new SubProgressMonitor(request.getMonitor(), 1));
            try {
                p.findReferencesToRename(request, status);
            }
            finally {
                request.popMonitor().done();
            }
            if (!status.hasFatalError()) continue;
            throw new SearchException(status.getEntryWithHighestSeverity().getMessage());
        }
    }

    public List<IRefactorRenameProcess> getProcesses(RefactoringRequest request) {
        return this.requestToProcesses.get(request);
    }

    public HashSet<ASTEntry> getLocalReferences(RefactoringRequest request) {
        HashSet<ASTEntry> allReferences = new HashSet<ASTEntry>();
        for (IRefactorRenameProcess p : this.requestToProcesses.get(request)) {
            HashSet<ASTEntry> references = p.getOccurrences();
            if (references == null) continue;
            allReferences.addAll(references);
        }
        return allReferences;
    }

    public Map<Tuple<String, File>, HashSet<ASTEntry>> getWorkspaceReferences(RefactoringRequest request) {
        HashMap<Tuple<String, File>, HashSet<ASTEntry>> allReferences = new HashMap<Tuple<String, File>, HashSet<ASTEntry>>();
        for (IRefactorRenameProcess p : this.requestToProcesses.get(request)) {
            Map<Tuple<String, File>, HashSet<ASTEntry>> references = p.getOccurrencesInOtherFiles();
            if (references == null) continue;
            for (Map.Entry<Tuple<String, File>, HashSet<ASTEntry>> reference : references.entrySet()) {
                Tuple<String, File> key = reference.getKey();
                HashSet<Object> existingReferences = allReferences.get(key);
                if (existingReferences == null) {
                    existingReferences = new HashSet();
                    allReferences.put(key, existingReferences);
                }
                existingReferences.addAll((Collection<ASTEntry>)reference.getValue());
            }
        }
        return allReferences;
    }

    public static class SearchException
    extends Exception {
        public SearchException(String message) {
            super(message);
        }
    }
}

