/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.refactoring.wizards.TextInputWizardPage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.editor.refactoring.IPyRefactoringRequest;
import org.python.pydev.editor.refactoring.MultiModuleMoveRefactoringRequest;
import org.python.pydev.plugin.preferences.PydevPrefs;

public class PyRenameRefactoringWizard
extends RefactoringWizard {
    private static final String UPDATE_REFERENCES = "UPDATE_REFERENCES";
    private final String fInputPageDescription;
    private IPyRefactoringRequest fRequest;
    private TextInputWizardPage inputPage;
    private String fInitialSetting;

    public PyRenameRefactoringWizard(Refactoring refactoring, String defaultPageTitle, String inputPageDescription, IPyRefactoringRequest request) {
        super(refactoring, 4);
        this.setDefaultPageTitle(defaultPageTitle);
        this.fInputPageDescription = inputPageDescription;
        this.fRequest = request;
        this.fInitialSetting = request.getInitialName();
        Assert.isNotNull((Object)this.fInitialSetting);
    }

    protected void addUserInputPages() {
        this.inputPage = this.createInputPage(this.fInputPageDescription, this.fInitialSetting);
        this.addPage((IWizardPage)this.inputPage);
    }

    protected TextInputWizardPage createInputPage(String message, String initialSetting) {
        return new TextInputWizardPage(message, true, initialSetting){

            @Override
            protected RefactoringStatus validateTextField(String text) {
                RefactoringStatus status = new RefactoringStatus();
                if (PyStringUtils.isValidIdentifier((String)text, (boolean)PyRenameRefactoringWizard.this.fRequest.isModuleRenameRefactoringRequest())) {
                    PyRenameRefactoringWizard.this.fRequest.setInputName(text);
                } else {
                    status.addFatalError("The name: " + text + " is not a valid identifier.");
                }
                return status;
            }

            @Override
            protected Text createTextInputField(Composite parent, int style) {
                Text ret = super.createTextInputField(parent, style);
                String text = ret.getText();
                int i = text.lastIndexOf(46);
                if (i >= 0) {
                    ret.setSelection(i + 1, text.length());
                } else {
                    ret.selectAll();
                }
                return ret;
            }

            @Override
            protected void textModified(String text) {
                if (PyRenameRefactoringWizard.this.fRequest instanceof MultiModuleMoveRefactoringRequest) {
                    RefactoringStatus status;
                    if (text.length() == 0) {
                        status = new RefactoringStatus();
                        status.addInfo("Empty text: move to source foder");
                    } else {
                        status = this.validateTextField(text);
                    }
                    if (!status.hasFatalError()) {
                        PyRenameRefactoringWizard.this.fRequest.setInputName(text);
                    }
                    this.setPageComplete(status);
                } else {
                    super.textModified(text);
                }
            }

            public void createControl(Composite parent) {
                Composite superComposite = new Composite(parent, 0);
                this.setControl((Control)superComposite);
                this.initializeDialogUnits((Control)superComposite);
                superComposite.setLayout((Layout)new GridLayout());
                Composite composite = new Composite(superComposite, 0);
                composite.setLayoutData((Object)new GridData(768));
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                layout.verticalSpacing = 8;
                composite.setLayout((Layout)layout);
                Label label = new Label(composite, 0);
                label.setText("New &value:");
                Text text = this.createTextInputField(composite);
                GridData gd = new GridData(768);
                gd.widthHint = this.convertWidthInCharsToPixels(25);
                text.setLayoutData((Object)gd);
                if (PyRenameRefactoringWizard.this.fRequest.isModuleRenameRefactoringRequest()) {
                    PyRenameRefactoringWizard.this.addOptionalUpdateReferencesCheckbox(composite);
                }
                Dialog.applyDialogFont((Control)superComposite);
            }
        };
    }

    protected void addOptionalUpdateReferencesCheckbox(Composite result) {
        final Button updateReferences = new Button(result, 32);
        updateReferences.setText("&Update References?");
        IPreferenceStore preferences = PydevPrefs.getPreferences();
        preferences.setDefault(UPDATE_REFERENCES, true);
        boolean updateRefs = preferences.getBoolean(UPDATE_REFERENCES);
        updateReferences.setSelection(updateRefs);
        this.fRequest.setUpdateReferences(updateRefs);
        updateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore preferences = PydevPrefs.getPreferences();
                boolean updateRefs = updateReferences.getSelection();
                preferences.setValue(PyRenameRefactoringWizard.UPDATE_REFERENCES, updateRefs);
                PyRenameRefactoringWizard.this.fRequest.setUpdateReferences(updateRefs);
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        updateReferences.setLayoutData((Object)gridData);
    }
}

