/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import sun.misc.Unsafe;

public abstract class MemoryIO {
    private Foreign foreign = Foreign.getInstance();
    private static final long ADDRESS_MASK;

    public static MemoryIO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private MemoryIO() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MemoryIO newMemoryIO() {
        try {
            MemoryIO memoryIO;
            if (!Boolean.getBoolean("jffi.unsafe.disabled") && MemoryIO.isUnsafeAvailable()) {
                Platform platform = Platform.getPlatform();
                if (Platform.getCPU().dataModel != 32) return new UnsafeImpl64(0);
                memoryIO = new UnsafeImpl32(0);
                return memoryIO;
            } else {
                memoryIO = MemoryIO.newNativeImpl();
            }
            return memoryIO;
        }
        catch (Throwable throwable) {
            return MemoryIO.newNativeImpl();
        }
    }

    private static MemoryIO newNativeImpl() {
        Platform platform = Platform.getPlatform();
        if (Platform.getCPU().dataModel == 32) {
            return new NativeImpl32(0);
        }
        return new NativeImpl64(0);
    }

    public abstract byte getByte(long var1);

    public abstract short getShort(long var1);

    public abstract int getInt(long var1);

    public abstract long getLong(long var1);

    public abstract float getFloat(long var1);

    public abstract double getDouble(long var1);

    public abstract long getAddress(long var1);

    public abstract void putByte(long var1, byte var3);

    public abstract void putShort(long var1, short var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putLong(long var1, long var3);

    public abstract void putFloat(long var1, float var3);

    public abstract void putDouble(long var1, double var3);

    public abstract void putAddress(long var1, long var3);

    public final void copyMemory(long src, long dst, long size) {
        if (dst + size <= src || src + size <= dst) {
            this._copyMemory(src, dst, size);
            return;
        }
        long l = size;
        long l2 = src;
        long l3 = dst;
        Foreign.memmove(l3, l2, l);
    }

    abstract void _copyMemory(long var1, long var3, long var5);

    public abstract void setMemory(long var1, long var3, byte var5);

    public static void putByteArray(long address, byte[] data, int offset, int length) {
        Foreign.putByteArray(address, data, offset, length);
    }

    public static void getByteArray(long address, byte[] data, int offset, int length) {
        Foreign.getByteArray(address, data, offset, length);
    }

    public static void putShortArray(long address, short[] data, int offset, int length) {
        Foreign.putShortArray(address, data, offset, length);
    }

    public static void getShortArray(long address, short[] data, int offset, int length) {
        Foreign.getShortArray(address, data, offset, length);
    }

    public static void putIntArray(long address, int[] data, int offset, int length) {
        Foreign.putIntArray(address, data, offset, length);
    }

    public static void getIntArray(long address, int[] data, int offset, int length) {
        Foreign.getIntArray(address, data, offset, length);
    }

    public static void putLongArray(long address, long[] data, int offset, int length) {
        Foreign.putLongArray(address, data, offset, length);
    }

    public static void getLongArray(long address, long[] data, int offset, int length) {
        Foreign.getLongArray(address, data, offset, length);
    }

    public static void putFloatArray(long address, float[] data, int offset, int length) {
        Foreign.putFloatArray(address, data, offset, length);
    }

    public static void getFloatArray(long address, float[] data, int offset, int length) {
        Foreign.getFloatArray(address, data, offset, length);
    }

    public static void putDoubleArray(long address, double[] data, int offset, int length) {
        Foreign.putDoubleArray(address, data, offset, length);
    }

    public static void getDoubleArray(long address, double[] data, int offset, int length) {
        Foreign.getDoubleArray(address, data, offset, length);
    }

    public static long allocateMemory(long size, boolean clear) {
        return Foreign.allocateMemory(size, clear) & ADDRESS_MASK;
    }

    public static void freeMemory(long address) {
        Foreign.freeMemory(address);
    }

    public static long getStringLength(long address) {
        return Foreign.strlen(address);
    }

    public static byte[] getZeroTerminatedByteArray(long address) {
        return Foreign.getZeroTerminatedByteArray(address);
    }

    public static byte[] getZeroTerminatedByteArray(long address, int maxlen) {
        return Foreign.getZeroTerminatedByteArray(address, maxlen);
    }

    public static void putZeroTerminatedByteArray(long address, byte[] data, int offset, int length) {
        Foreign.putZeroTerminatedByteArray(address, data, offset, length);
    }

    public static long indexOf(long address, byte value) {
        long location = Foreign.memchr(address, value, Integer.MAX_VALUE);
        if (location != 0L) {
            return location - address;
        }
        return -1L;
    }

    public static long indexOf(long address, byte value, int maxlen) {
        long location = Foreign.memchr(address, value, maxlen);
        if (location != 0L) {
            return location - address;
        }
        return -1L;
    }

    public final long getDirectBufferAddress(Buffer buffer) {
        return this.foreign.getDirectBufferAddress(buffer);
    }

    private static boolean isUnsafeAvailable() {
        try {
            Class<?> sunClass = Class.forName("sun.misc.Unsafe");
            Class[] primitiveTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            Class[] arr$ = primitiveTypes;
            for (int i$ = 0; i$ < 6; ++i$) {
                Class type;
                Class clazz = type = arr$[i$];
                Class<?> clazz2 = sunClass;
                String string = clazz.getSimpleName();
                String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
                Method method = clazz2.getDeclaredMethod("get" + string2, Long.TYPE);
                if (!method.getReturnType().equals(clazz)) {
                    throw new NoSuchMethodException("Incorrect return type for " + method.getName());
                }
                clazz2.getDeclaredMethod("put" + string2, Long.TYPE, clazz);
            }
            sunClass.getDeclaredMethod("getAddress", Long.TYPE);
            sunClass.getDeclaredMethod("putAddress", Long.TYPE, Long.TYPE);
            sunClass.getDeclaredMethod("allocateMemory", Long.TYPE);
            sunClass.getDeclaredMethod("freeMemory", Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static /* synthetic */ MemoryIO access$000() {
        return MemoryIO.newMemoryIO();
    }

    /* synthetic */ MemoryIO(byte by) {
        this();
    }

    static {
        Platform platform = Platform.getPlatform();
        ADDRESS_MASK = Platform.getCPU().addressMask;
    }

    static final class UnsafeImpl64
    extends UnsafeImpl {
        private UnsafeImpl64() {
            super((byte)0);
        }

        public final long getAddress(long address) {
            return unsafe.getLong(address);
        }

        public final void putAddress(long address, long value) {
            unsafe.putLong(address, value);
        }

        /* synthetic */ UnsafeImpl64(byte by) {
            this();
        }
    }

    static final class UnsafeImpl32
    extends UnsafeImpl {
        private UnsafeImpl32() {
            super((byte)0);
        }

        public final long getAddress(long address) {
            return (long)unsafe.getInt(address) & ADDRESS_MASK;
        }

        public final void putAddress(long address, long value) {
            unsafe.putInt(address, (int)value);
        }

        /* synthetic */ UnsafeImpl32(byte by) {
            this();
        }
    }

    static abstract class UnsafeImpl
    extends MemoryIO {
        protected static Unsafe unsafe = (Unsafe)Unsafe.class.cast(UnsafeImpl.getUnsafe());

        private UnsafeImpl() {
            super((byte)0);
        }

        private static Object getUnsafe() {
            try {
                Class<?> sunUnsafe = Class.forName("sun.misc.Unsafe");
                Field f = sunUnsafe.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return f.get(sunUnsafe);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public final byte getByte(long address) {
            return unsafe.getByte(address);
        }

        public final short getShort(long address) {
            return unsafe.getShort(address);
        }

        public final int getInt(long address) {
            return unsafe.getInt(address);
        }

        public final long getLong(long address) {
            return unsafe.getLong(address);
        }

        public final float getFloat(long address) {
            return unsafe.getFloat(address);
        }

        public final double getDouble(long address) {
            return unsafe.getDouble(address);
        }

        public final void putByte(long address, byte value) {
            unsafe.putByte(address, value);
        }

        public final void putShort(long address, short value) {
            unsafe.putShort(address, value);
        }

        public final void putInt(long address, int value) {
            unsafe.putInt(address, value);
        }

        public final void putLong(long address, long value) {
            unsafe.putLong(address, value);
        }

        public final void putFloat(long address, float value) {
            unsafe.putFloat(address, value);
        }

        public final void putDouble(long address, double value) {
            unsafe.putDouble(address, value);
        }

        public final void _copyMemory(long src, long dst, long size) {
            unsafe.copyMemory(src, dst, size);
        }

        public final void setMemory(long src, long size, byte value) {
            unsafe.setMemory(src, size, value);
        }

        /* synthetic */ UnsafeImpl(byte by) {
            this();
        }
    }

    static final class NativeImpl64
    extends NativeImpl {
        private NativeImpl64() {
            super((byte)0);
        }

        public final long getAddress(long address) {
            return Foreign.getLong(address);
        }

        public final void putAddress(long address, long value) {
            Foreign.putLong(address, value);
        }

        /* synthetic */ NativeImpl64(byte by) {
            this();
        }
    }

    static final class NativeImpl32
    extends NativeImpl {
        private NativeImpl32() {
            super((byte)0);
        }

        public final long getAddress(long address) {
            return (long)Foreign.getInt(address) & ADDRESS_MASK;
        }

        public final void putAddress(long address, long value) {
            Foreign.putInt(address, (int)value);
        }

        /* synthetic */ NativeImpl32(byte by) {
            this();
        }
    }

    static abstract class NativeImpl
    extends MemoryIO {
        private NativeImpl() {
            super((byte)0);
        }

        public final byte getByte(long address) {
            return Foreign.getByte(address);
        }

        public final short getShort(long address) {
            return Foreign.getShort(address);
        }

        public final int getInt(long address) {
            return Foreign.getInt(address);
        }

        public final long getLong(long address) {
            return Foreign.getLong(address);
        }

        public final float getFloat(long address) {
            return Foreign.getFloat(address);
        }

        public final double getDouble(long address) {
            return Foreign.getDouble(address);
        }

        public final void putByte(long address, byte value) {
            Foreign.putByte(address, value);
        }

        public final void putShort(long address, short value) {
            Foreign.putShort(address, value);
        }

        public final void putInt(long address, int value) {
            Foreign.putInt(address, value);
        }

        public final void putLong(long address, long value) {
            Foreign.putLong(address, value);
        }

        public final void putFloat(long address, float value) {
            Foreign.putFloat(address, value);
        }

        public final void putDouble(long address, double value) {
            Foreign.putDouble(address, value);
        }

        public final void setMemory(long address, long size, byte value) {
            Foreign.setMemory(address, size, value);
        }

        public final void _copyMemory(long src, long dst, long size) {
            Foreign.copyMemory(src, dst, size);
        }

        /* synthetic */ NativeImpl(byte by) {
            this();
        }
    }

    static final class SingletonHolder {
        private static final MemoryIO INSTANCE = MemoryIO.access$000();
    }
}

